% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{pairwiseDist}
\alias{pairwiseDist}
\title{Calculate pairwise distances between sequences}
\usage{
pairwiseDist(seq, dist_mat = getDNAMatrix())
}
\arguments{
\item{seq}{character vector containing a DNA sequences.}

\item{dist_mat}{Character distance matrix. Defaults to a Hamming distance 
matrix returned by \link{getDNAMatrix}. If gap 
characters, \code{c("-", ".")}, are assigned a value of -1 
in \code{dist_mat} then contiguous gaps of any run length,
which are not present in both sequences, will be counted as a 
distance of 1. Meaning, indels of any length will increase
the sequence distance by 1. Gap values other than -1 will 
return a distance that does not consider indels as a special case.}
}
\value{
A matrix of numerical distance between each entry in \code{seq}. 
          If \code{seq} is a named vector, row and columns names will be added 
          accordingly.

          Amino acid distance matrix may be built with \link{getAAMatrix}. 
          Uses \link{seqDist} for calculating distances between pairs.
          See \link{pairwiseEqual} for generating an equivalence matrix.
}
\description{
\code{pairwiseDist} calculates all pairwise distance between a set of sequences.
}
\examples{
# Gaps will be treated as Ns with a gap=0 distance matrix
pairwiseDist(c(A="ATGGC", B="ATGGG", C="ATGGG", D="AT--C"), 
             dist_mat=getDNAMatrix(gap=0))

# Gaps will be treated as universally non-matching characters with gap=1
pairwiseDist(c(A="ATGGC", B="ATGGG", C="ATGGG", D="AT--C"), 
             dist_mat=getDNAMatrix(gap=1))

# Gaps of any length will be treated as single mismatches with a gap=-1 distance matrix
pairwiseDist(c(A="ATGGC", B="ATGGG", C="ATGGG", D="AT--C"), 
             dist_mat=getDNAMatrix(gap=-1))

}
