% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alf_session.R
\name{alf_session.is_valid}
\alias{alf_session.is_valid}
\title{Determine whether a session is valid.}
\usage{
alf_session.is_valid(session)
}
\arguments{
\item{session}{session}
}
\value{
\code{TRUE} if the session is valid, \code{FALSE} otherwise
}
\description{
Determines whether a given session is still valid or not.
}
\examples{
# try to establish a connection to the alfresco content repository
my_session <-
  tryCatch(
    alf_session("http://localhost:8080", "admin", "admin"),
    error = function(e) NULL)

if (!is.null(my_session)) {

  # output session information
  print(paste("Session: [ticket = ", my_session$ticket,
                      ", server = ", my_session$server, "]", sep=""))

  # verify that the session is valid
  if (alf_session.is_valid(my_session)) print("Session verified as valid.")

  # invalidate the session so that it can no longer be used
  alf_session.invalidate(my_session)
}
}
