% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval.R
\name{interval}
\alias{interval}
\title{Interval}
\description{
An interval is a support that is a finite union of intervals.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{lower}}{A numeric vector of lower bounds.}

\item{\code{upper}}{A numeric vector of upper bounds.}

\item{\code{lower_closed}}{A logical vector indicating whether the lower bound is
closed.}

\item{\code{upper_closed}}{A logical vector indicating whether the upper bound is
closed.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-interval-new}{\code{interval$new()}}
\item \href{#method-interval-is_empty}{\code{interval$is_empty()}}
\item \href{#method-interval-has}{\code{interval$has()}}
\item \href{#method-interval-infimum}{\code{interval$infimum()}}
\item \href{#method-interval-supremum}{\code{interval$supremum()}}
\item \href{#method-interval-dim}{\code{interval$dim()}}
\item \href{#method-interval-clone}{\code{interval$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-interval-new"></a>}}
\if{latex}{\out{\hypertarget{method-interval-new}{}}}
\subsection{Method \code{new()}}{
Initialize an interval.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{interval$new(
  lower = -Inf,
  upper = Inf,
  lower_closed = FALSE,
  upper_closed = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lower}}{A numeric vector of lower bounds.}

\item{\code{upper}}{A numeric vector of upper bounds.}

\item{\code{lower_closed}}{A logical vector indicating whether the lower
bound is closed.}

\item{\code{upper_closed}}{A logical vector indicating whether the upper
bound is closed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-interval-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-interval-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
Determine if the interval is empty
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{interval$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A logical vector indicating whether the interval is empty.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-interval-has"></a>}}
\if{latex}{\out{\hypertarget{method-interval-has}{}}}
\subsection{Method \code{has()}}{
Determine if a value is contained in the interval.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{interval$has(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A numeric vector of values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical vector indicating whether each value is contained
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-interval-infimum"></a>}}
\if{latex}{\out{\hypertarget{method-interval-infimum}{}}}
\subsection{Method \code{infimum()}}{
Get the infimum of the interval.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{interval$infimum()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric vector of infimums.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-interval-supremum"></a>}}
\if{latex}{\out{\hypertarget{method-interval-supremum}{}}}
\subsection{Method \code{supremum()}}{
Get the supremum of the interval.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{interval$supremum()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric vector of supremums.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-interval-dim"></a>}}
\if{latex}{\out{\hypertarget{method-interval-dim}{}}}
\subsection{Method \code{dim()}}{
Get the dimension of the interval.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{interval$dim()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The dimension of the interval.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-interval-clone"></a>}}
\if{latex}{\out{\hypertarget{method-interval-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{interval$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
