% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algo.R
\name{algo}
\alias{algo}
\title{Implement the Algolia Places address search-autocompletion menu on shiny text inputs}
\usage{
algo(element, type = "address", language = "en_US", countries = NULL)
}
\arguments{
\item{element}{the shiny text element that will be used for the Algolia Places autocompletion menu}

\item{type}{Restrict the search results to a specific type. The user can choose from "city", "country", "address", "busStop", "trainStation", "townhall" and airport. Defaults to "address".}

\item{language}{Get the results in a specific language. The user can pass two letters language codes (ISO 639-1). Defaults to "en_US"}

\item{countries}{Change the countries to search in. The user can pass a vector of two letters country codes (ISO 639-1). Defaults to the whole world.}
}
\value{
An address search-autocompletion menu on shiny text inputs
}
\description{
In order to use this function, the user must get an application ID and an API key from the Algolia website
and store them within her environment (please refer to the package's vignette). He must also put the use_algolia() function at the beginning of her shiny ui.
}
