% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood-space.R
\name{likelihood_space}
\alias{likelihood_space}
\title{Calculate log-likelihood space for a given time series and data}
\usage{
likelihood_space(
  y,
  mu = NULL,
  pi = NULL,
  data = NULL,
  growth = TRUE,
  type = "exponential",
  centers,
  ranges,
  steps_from_centers,
  calculate = TRUE
)
}
\arguments{
\item{y}{either a vector describing the number of discovered alien and invasive species (IAS) over a given time period, or the name (quoted or unquoted) of the corresponding column in the provided data.}

\item{mu}{a formula defining the predictors for \eqn{\mu_t}, the annual introduction rate. Formulas should be provided in the syntax \code{~ x1 + x2 + ... + xn}. Use \code{~ 1} for an intercept only model.}

\item{pi}{a formula defining the predictors for \eqn{\Pi_{st}}, the annual probability of detection. Formulas should be provided in the syntax \code{~ x1 + x2 + ... + xn}. Use \code{~ 1} for an intercept only model.}

\item{data}{a data frame containing the variables in the model(s).}

\item{growth}{logical. Should the population growth parameter \eqn{\gamma_2} be included in the model for \eqn{\Pi_{st}}?. Note that values for \code{init}, if provided, need to include an initial value for the growth parameter, when \code{growth = TRUE}.}

\item{type}{Define whether the mu function should be on "linear" or "exponential" scale. Defaults to "exponential".}

\item{centers}{the values used as the center-points for the parameter values. Usually the maximum likelihood estimation from a call to \code{snc}. Length should be either 1 or correspond to number of parameters (including the growth parameter).}

\item{ranges}{the range of the parameter values in term of the center. The values will be withing \code{center - (center * range)} and \code{center + (center * range)}. Length should be either 1 or correspond to number of parameters (including the growth parameter).}

\item{steps_from_centers}{How many values in the range between \code{center} and \code{center + (center * range)} should be included in the set. Length should be either 1 or correspond to number of parameters (including the growth parameter).}

\item{calculate}{Whether to calculate the log-likelihoods (TRUE) or just view the parameter values (FALSE).}
}
\value{
A data frame containing the parameter values, and if \code{calculate = TRUE} including the log-likelihood values for each parameter combination.
}
\description{
This function allows to calculate the log-likelihood values for a given set of parameter values.
It can be used for diagnostics of the likelihood space and check - among others - for parameter contribution to log-likelihood.
passing \code{FALSE} for the \code{calculate} argument allows to experiment with different parameter values sets before calculating their log-likelihoods.
Please note: This functions may take a lot of time, depending on the number of parameters, and steps!
}
\examples{
\donttest{
if (FALSE){ # this takes a while...
example_model <- snc(sfestuary)
estimates <- example_model$coefficients$Estimate

likelihood_space <- likelihood_space(y = sfestuary, centers = estimates,
                                     ranges = 1.5, steps_from_center = 10,
                                     calculate = TRUE)

# with specified formula:
example_buba <- snc(y = aliens, pi = ~ natives, data = medfish)
estimates <- example_buba$coefficients$Estimate

likelihood_space <- likelihood_space(y = aliens, pi = ~ natives,
                                     data = medfish, centers = estimates,
                                     ranges = 1.5, steps_from_center = 10,
                                     calculate = TRUE)
 }
}
}
