# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate likelihood of two beta-sharing candidate alpha-beta pairs deriving from a dual clone
#'
#' \code{dual_discrim_dual_likelihood()} is used within \code{\link{dual_top}}
#' to calculate the likelihood that two alpha-beta pairs identified by
#' \code{\link{bagpipe}} sharing the same beta chain derive from a single
#' dual-alpha clone (instead of two distinct clones sharing the same beta).
#'
#'
#' @param est Frequency estimate of the putative dual-alpha clone
#' @param err Mean drop error rate
#' @param numb_cells Vector containing the number of cells per well
#' @param numb_wells Vector containing the number of wells with the sample
#'    sizes given by \code{numb_cells}
#' @param binomials Calculations of the needed binomial coefficients; this is
#'    faster in R than in Rcpp (from my own tests)
#'
#' @return A numeric containing the negative log likelihood
#'
#' @export
dual_discrim_dual_likelihood <- function(est, err, numb_cells, numb_wells, binomials) {
    .Call('alphabetr_dual_discrim_dual_likelihood', PACKAGE = 'alphabetr', est, err, numb_cells, numb_wells, binomials)
}

#' Calculate likelihood of two beta-sharing candidate alpha-beta pairs deriving from a dual clone
#'
#' \code{dual_discrim_shared_likelihood()} is used within \code{\link{dual_top}}
#' to calculate the likelihood that two alpha-beta pairs identified by
#' \code{\link{bagpipe}} sharing the same beta chain derive from a two
#' distinct clones sharing the same beta chain dual-alpha clone (instead of
#' a single dual-alpha clone)
#'
#' @param est1 Frequency estimate of the first alpha-beta clone
#' @param est2 Frequency estimate of the second alpha-beta clone
#' @param err Mean drop error rate
#' @param numb_cells Vector containing the number of cells per well
#' @param numb_wells Vector containing the number of wells with the sample
#'    sizes given by \code{numb_cells}
#' @param binomials Calculations of the needed binomial coefficients; this is
#'    faster in R than in Rcpp (from my own tests)
#' @param multinomials Calculations of the needed multinomial coefficients;
#'    this is way faster in R due to vectorization
#'
#' @return A numeric containing the negative log likelihood
#' @export
dual_discrim_shared_likelihood <- function(est1, est2, err, numb_cells, numb_wells, binomials, multinomials) {
    .Call('alphabetr_dual_discrim_shared_likelihood', PACKAGE = 'alphabetr', est1, est2, err, numb_cells, numb_wells, binomials, multinomials)
}

#' Calculate likelihood curve of frequency estimates for a dual-alpha or
#' dual-beta TCR clone
#'
#' @param est Clonal frequency estimate
#' @param err Mean drop error rate
#' @param numb_cells A vector of the distinct sample sizes, i.e. the number of
#'    cells per well
#' @param numb_wells A vector with the number of wells with the distinct
#'    sample sizes
#' @param numb_sample A vector with the number of wells of the sample size of
#'    the same position of \code{numb_cells} that contains both alpha and the
#'    beta chain of the clone (for dual-alpha clones) or both beta and the
#'    alpha chain of the clone (for dual-beta clones)
#'
#' @return A numeric with the negative log likelihood
likelihood_dual <- function(est, err, numb_wells, numb_cells, numb_sample) {
    .Call('alphabetr_likelihood_dual', PACKAGE = 'alphabetr', est, err, numb_wells, numb_cells, numb_sample)
}

#' Calculate likelihood curve of frequency estimates for a dual-alpha and
#' dual-beta TCR clone
#'
#' @param est Clonal frequency estimate
#' @param err Mean drop error rate
#' @param numb_cells A vector of the distinct sample sizes, i.e. the number of
#'    cells per well
#' @param numb_wells A vector with the number of wells with the distinct
#'    sample sizes
#' @param numb_sample A vector  with the number of wells of the sample size of
#'    the same position of \code{numb_cells} that contains both alpha and both
#'    betachains the clone
#'
#' @return A numeric with the negative log likelihood
likelihood_dualdual <- function(est, err, numb_wells, numb_cells, numb_sample) {
    .Call('alphabetr_likelihood_dualdual', PACKAGE = 'alphabetr', est, err, numb_wells, numb_cells, numb_sample)
}

#' Calculate likelihood curve of frequency estimates for a single TCR clone
#'
#' @param est Clonal frequency estimate
#' @param err Mean drop error rate
#' @param numb_cells A vector of the distinct sample sizes, i.e. the number of
#'    cells per well
#' @param numb_wells A vector with the number of wells with the distinct
#'    sample sizes
#' @param numb_sample A vector with the number of wells of the sample size of
#'    the same position of \code{numb_cells} that contains the alpha and beta
#'    chains the clone
#'
#' @return A numeric with the negative log likelihood
#'
#' @export
likelihood_single <- function(est, err, numb_wells, numb_cells, numb_sample) {
    .Call('alphabetr_likelihood_single', PACKAGE = 'alphabetr', est, err, numb_wells, numb_cells, numb_sample)
}

