% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_estimate.R
\name{freq_estimate}
\alias{freq_estimate}
\title{Estimation of frequencies of clones identified by \code{alphabetr}}
\usage{
freq_estimate(alpha, beta, pair, error = 0.15, numb_cells)
}
\arguments{
\item{alpha}{Matrix recording which alpha chains appear in each well of the
data. See \code{\link{create_data}}.}

\item{beta}{Matrix recording which beta chains appear in the each well of the
data. See \code{\link{create_data}}.}

\item{pair}{A matrix where each row is a beta/alpha pair, column 1 and 2 are
the beta indices, and column 3 and 4 are the alpha indices, and column 5
is the proportion of replicates the clone was found in (or equal to -1 if
the clone is dual)}

\item{error}{The mean error "dropped" chain rate due to PCR or sequencing
errors.}

\item{numb_cells}{The number of cells per well in each column of the plates.
Should be a vector of 12 elements.}
}
\value{
A data frame with frequency estimates and confidence intervals
}
\description{
\code{freq_estimate()} estimates the frequencies of clones with confidence
   intervals by using a maximum likelihood approach. The function looks at
   the wells that a chains of a clone appear in and determines the most
   likely frequency that explains the data.
}
\examples{
 \dontrun{
 # obtained from the output of bagpipe()
 pairs <- pairs[pairs[, 5] > 0.3, ]
 freq  <- freq_estimate(alpha = dat$alpha,
                        beta = dat$beta,
                        pair = pairs,
                        numb_cells = matrix(c(50, 480), ncol = 2))
 }
}

