% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{test_asymnorm_est_dev}
\alias{test_asymnorm_est_dev}
\title{Computing the feasible statistic of the trawl function CLT}
\usage{
test_asymnorm_est_dev(
  ahat,
  n,
  Delta,
  k,
  c4,
  varlevyseed = 1,
  trawlfct,
  trawlfct_par,
  avector
)
}
\arguments{
\item{ahat}{The estimated trawl function at time t: \eqn{\hat{a}(t)}}

\item{n}{The number of observations in the data set}

\item{Delta}{The width Delta of the observation grid}

\item{k}{The time point in \eqn{0, 1, \ldots, n-1};
the test statistic will be computed for the time point \eqn{k * \Delta_n}.}

\item{c4}{The fourth cumulant of the Levy seed of the trawl process}

\item{varlevyseed}{The variance of the Levy seed of the trawl process,
the default is 1}

\item{trawlfct}{The trawl function for which the
asymptotic variance will be computed (Exp, supIG or LM)}

\item{trawlfct_par}{The parameter vector of the trawl function
(Exp: lambda, supIG: delta, gamma, LM: alpha, H)}

\item{avector}{The vector \eqn{(\hat a(0), \hat a(Delta_n), ...,
\hat a((n-1)\Delta_n))}}
}
\value{
The function returns the feasible statistic \eqn{T( \Delta_n)_n}
if the estimated asymptotic variance is positive and 999 otherwise.
}
\description{
This function computes the feasible test statistic appearing in the CLT
for the trawl function estimation.
}
\details{
As derived in
Sauri and Veraart (2022), the feasible statistic is given by
\deqn{T(k \Delta_n)_n:=\frac{\sqrt{n\Delta_{n}}}{
\sqrt{\widehat{\sigma_{a}^2( \Delta_n)}}}
\left(\hat{a}( \Delta_n)-a( \Delta_n)\right)}.
}
