% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv_pn_test.R
\name{mv_pn_test}
\alias{mv_pn_test}
\title{Runs a multivariate point null test. This function returns
an approximate p-value for the specified test statistic.}
\usage{
mv_pn_test(obs_data, param_est = NULL, control = test.control())
}
\arguments{
\item{obs_data}{The observed data to be used for finding the optimal
norm (training), and finding the test statistic (testing).  Similar to
above, each row is an observation and each column corresponds to either
the outcome (first column) or a covariate.}

\item{param_est}{Function used to estimate the parameter and corresponding
influence curve.}

\item{control}{List used to define controls for test.}
}
\value{
The test will always return the following output:

- \code{pvalue}: The approximate value of the test statistic

- \code{test_stat}: The approximate value of the test statistic

- \code{test_st_eld}: The approximate limiting distribution of the test statistic
 (with length equal to \code{ts_ld_bs_samp}).

- \code{chosen_norm}: A vector indicating which norm was chosen by
the adaptive test

- \code{param_ests}: The parameter estimate.

- \code{param_ses}: An estimate of the standard error of
 each element of \code{param_ests}

- \code{oth_ic_inf}: Any other information provided by the \code{param_est}
 function when calculating the IC and parameter estimates.
Additional information may be returned by specifying it in the
test.control function:

- If \code{"var_est"} is contained in \code{other_output}, the test output
will contain will have \code{var_mat} returned which is the empirical
second moment of the IC (equal asymptotically to the variance estimator).

- If \code{"obs_data"} is contained in the \code{other_output}, the test
output will return the data passed to the testing function.
}
\description{
Runs a multivariate point null test. This function returns
an approximate p-value for the specified test statistic.
}
\examples{
set.seed(10)
## NOTE: More monte-carlo samples should be taken are taken here.  This is
## only done to lower computation time.
test <- mv_pn_test(data.frame(y = rnorm(100), x = rnorm(100)),
                   ic.pearson, test.control(n_peld_mc_samples = 20,
                                            ts_ld_bs_samp = 20))

}
