% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cci.R
\name{cci}
\alias{cci}
\title{Calculate Charlson Comorbidity Index}
\usage{
cci(my_data, replace_na_with_zero = FALSE)
}
\arguments{
\item{my_data}{A data frame containing the necessary columns for score calculation (17 columns). The columns should have values 0, 1, 2, or NA. Yes/no responses should be coded as yes-1, no-0.
For the column "liver_disease (None/Mild/Moderate to severe)", encode as None-0, Mild-1, Moderate to severe-2.
For the column "diabetes_mellitus (None or diet-controlled/uncomplicated/End-organ)", encode as None or diet-controlled-0, uncomplicated-1, End-organ-2.
For the column "solid_tumor (None/Localized/Metastatic)", encode as None-0, Localized-1, Metastatic-2.}

\item{replace_na_with_zero}{A boolean indicating whether to replace NA values with zero (no-0), except for age (default is FALSE).}
}
\value{
A data frame (my_data) with an additional column 'cci_score' containing the calculated scores and an additional column 'estimated_10_year_survival'. Returns NA for cases with missing values.
}
\description{
The Charlson Comorbidity Index is a tool used to assess the risk of mortality in patients with multiple comorbidities. This function calculates the Charlson Comorbidity Index (CCI) using various binary or ternary columns in a data frame.
}
\details{
The data frame should contain the following CCI items:
\itemize{
\item \code{age} : Age
\item \code{mi} : Myocardial infarction
\item \code{chf} : Congestive heart failure
\item \code{pvd} : Peripheral vascular disease
\item \code{cevd} : Cerebrovascular accident with minor or no residua and transient ischemic attacks
\item \code{dementia} : Dementia
\item \code{cpd} : Chronic obstructive pulmonary disease
\item \code{ctd} : Connective tissue disease
\item \code{pud} : Peptic ulcer disease
\item \code{liver_disease} : Liver disease
\item \code{diabetes_mellitus} : Diabetes mellitus
\item \code{hp} : Hemiplegia
\item \code{ckd} : Moderate to severe Chronic kidney disease
\item \code{solid_tumor} : Solid tumor
\item \code{leuk} : Leukemia
\item \code{lym} : Lymphoma
\item \code{aids} : AIDS
}
}
\examples{
set.seed(123)
n <- 10
my_data <- data.frame(
  age = sample(30:90, n, replace = TRUE), # age
  mi = sample(0:1, n, replace = TRUE), # Myocardial infraction
  chf = sample(0:1, n, replace = TRUE), # Congestive heart failure
  pvd = sample(0:1, n, replace = TRUE), # preripheral vascular disease
  cevd = sample(0:1, n, replace = TRUE), # Cerebrovascular accident or Transient ischemic attack
  dementia = sample(0:1, n, replace = TRUE), # Dematia
  cpd = sample(0:1, n, replace = TRUE),# Chronic obstructive pulmonary disease
  ctd = sample(0:1, n, replace = TRUE),# Connective tissue disease
  pud = c(sample(0:1, (n-1), replace = TRUE) , NA), # peptide ulcer disease
  liver_disease = sample(0:2, n, replace = TRUE), #Liver disease(None,Mild,Moderate to severe)
  diabetes_mellitus = sample(0:2, n, replace = TRUE),#Diabetes(None,uncomplicated,End-organ)
  hp = sample(0:1, n, replace = TRUE), # Hemipledia
  ckd = sample(0:1, n, replace = TRUE), #Moderate to severe Chronic kidney disease
  solid_tumor = sample(0:2, n, replace = TRUE), #Solid tumor(None,Localized,Metastatic)
  leuk = sample(0:1, n, replace = TRUE), # Leukemia
  lym =  c(sample(0:1, (n-2), replace = TRUE) , c(NA , NA)), # Lymphoma
  aids = sample(0:1, n, replace = TRUE) ) # AIDS

cci(my_data, replace_na_with_zero = FALSE)


}
\references{
Charlson et al. (1987) \url{doi:10.1016/0021-9681(87)90171-8}
}
