% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/c14_spd.R
\docType{methods}
\name{c14_spd}
\alias{c14_spd}
\alias{c14_spd-method}
\alias{c14_spd,CalibratedAges-method}
\title{Summed Probability Distributions}
\usage{
c14_spd(object, ...)

\S4method{c14_spd}{CalibratedAges}(object, normalize_date = FALSE, normalize_spd = FALSE)
}
\arguments{
\item{object}{A \code{\linkS4class{CalibratedAges}} object.}

\item{...}{Currently not used.}

\item{normalize_date}{A \code{\link{logical}} scalar: should the total probability mass
of the calibrated dates be normalised (to sum to unity within the time-span
of analysis)?}

\item{normalize_spd}{A \code{\link{logical}} scalar: should the total probability mass
of the SPD be normalised (to sum to unity)?}
}
\value{
A \code{\linkS4class{CalibratedSPD}} object.
}
\description{
Computes summed probability distributions (SPD) of radiocarbon dates.
}
\details{
Summed probability distributions (SPD) are not statistically valid
estimators of the calendar age of a potential future sample. They should not
be used in any dates-as-data approach to provide a population proxy.
}
\examples{
## Radiocarbon data from Bosch et al. 2015
data("ksarakil")

## Calibrate
cal <- c14_calibrate(
  values = ksarakil$date,
  errors = ksarakil$error,
  names = ksarakil$code,
  curves = "marine13",
  reservoir_offsets = 53,
  reservoir_errors = 43,
  from = 50000, to = 0
)
plot(cal, level = 0.68)

## SPD
s <- c14_spd(cal)
plot(s)
}
\seealso{
Other radiocarbon tools: 
\code{\link{F14C}},
\code{\link{c14_calibrate}()},
\code{\link{c14_combine}()},
\code{\link{c14_curve}()},
\code{\link{c14_ensemble}()},
\code{\link{c14_plot}},
\code{\link{c14_sample}()},
\code{\link{c14_uncalibrate}()},
\code{\link{rec_plot}}
}
\author{
N. Frerebeau
}
\concept{radiocarbon tools}
