% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reid.R
\name{compute_batched_distance_matrix}
\alias{compute_batched_distance_matrix}
\title{Computes the distance matrix in a batched manner to save memory.}
\usage{
compute_batched_distance_matrix(
  input1,
  input2,
  metric = "cosine",
  batch_size = 10
)
}
\arguments{
\item{input1}{2-D array of query features}

\item{input2}{2-D array of database features}

\item{metric}{The distance metric to use. Options include 'euclidean', 'cosine', etc}

\item{batch_size}{The number of rows from input1 to process at a time}
}
\value{
distance matrix
}
\description{
Computes the distance matrix in a batched manner to save memory.
}
\examples{
\dontrun{
dist_matrix <- compute_batched_distance_matrix(query_embeddings, database_embeddings, 
                                               metric='cosine', batch_size=12)}
}
