% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{train_val_test}
\alias{train_val_test}
\title{Splits the manifest into training validation and test datasets for training}
\usage{
train_val_test(
  manifest,
  label_col = "class",
  file_col = "filepath",
  conf_col = "confidence",
  out_dir = NULL,
  val_size = 0.1,
  test_size = 0.1,
  seed = 42
)
}
\arguments{
\item{manifest}{list of files to split for training}

\item{label_col}{column name containing class labels}

\item{file_col}{column containing file paths}

\item{conf_col}{column containing prediction confidence}

\item{out_dir}{location to save split lists to}

\item{val_size}{fraction of data dedicated to validation}

\item{test_size}{fraction of data dedicated to testing}

\item{seed}{RNG seed for reproducibility}
}
\value{
train manifest, validate manifest, test manifest
}
\description{
Splits the manifest into training validation and test datasets for training
}
\examples{
\dontrun{
  output <- train_val_test(manifest)
}
}
