% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nll_functions.R
\name{nll_frailty_logscale}
\alias{nll_frailty_logscale}
\title{Negative log-likelihood function: frailty variables on logscale}
\usage{
nll_frailty_logscale(
  log.a1 = log.a1,
  log.b1 = log.b1,
  log.a2 = log.a2,
  log.b2 = log.b2,
  log.theta = log.theta,
  data = data,
  time = time,
  censor = censor,
  infected_treatment = infected_treatment,
  d1 = "Weibull",
  d2 = "Weibull",
  d3 = ""
)
}
\arguments{
\item{log.a1, log.b1}{location and scale parameters for background mortality,
on a logscale}

\item{log.a2, log.b2}{location and scale parameters for mortality
due to infection, on a logscale}

\item{log.theta}{parameter describing variance of the unobserved variation
in virulence, on a logscale}

\item{data}{name of data frame containing survival data}

\item{time}{name of data frame column identifying time of event; time > 0}

\item{censor}{name of data frame column idenifying if event was death (0)
or right-censoring (1)}

\item{infected_treatment}{name of data frame column identifying if data
are from an infected (1) or uninfected (0) treatment}

\item{d1, d2}{names of probability distributions chosen to describe
background mortality and mortality due to infection, respectively;
both default to the Weibull distribution}

\item{d3}{name of probability distribution chosen to describe
unobserved frailty; choice of 'gamma' or 'inverse Gaussian'}
}
\value{
numeric
}
\description{
This negative log-likelihood (nll) function is the same as 'nll_frailty', except it assumes the variables to estimate are on a logscale.
}
\examples{

### Example 1: unobserved variation in virulence with gamma distribution

# step #1: parameterise nll function to be passed to 'mle2'
    m01_prep_function <- function(
      log.a1 = log.a1, log.b1 = log.b1,
      log.a2 = log.a2, log.b2 = log.b2,
      log.theta = log.theta){
        nll_frailty_logscale(
          log.a1 = log.a1, log.b1 = log.b1,
          log.a2 = log.a2, log.b2 = log.b2,
          log.theta = log.theta,
          data = data_lorenz,
          time = t,
          censor = censored,
          infected_treatment = g,
          d1 = "Gumbel", d2 = "Weibull", d3 = "Gamma"
          )}

# step #2: send 'prep_function' to 'mle2' for maximum likelihood estimation
    m01 <- mle2(
      m01_prep_function,
      start = list(
        log.a1 = 3, log.b1 = 1.5, log.a2 = 0.7, log.b2 = -0.7, log.theta = 1
        )
      )

  summary(m01)

  exp(coef(m01))

}
\seealso{
\code{\link{nll_frailty}}
}
