% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leverage_plot.R
\name{leverage_plot}
\alias{leverage_plot}
\title{Index plot of leverage values for \code{lm} object}
\usage{
leverage_plot(
  model,
  id_n = 3,
  add_reference = TRUE,
  ttype = "half",
  threshold = NULL,
  ...,
  text_arglist = list(),
  abline_arglist = list(),
  extendrange_f = 0.08
)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{id_n}{The number of points to identify with labels.
The default is \code{3}.}

\item{add_reference}{A logical value indicating whether a
reference line should be added. The default is
\code{TRUE}.}

\item{ttype}{Threshold type. The default is
\code{"half"}. The other options are \code{"2mean"} and
\code{"custom"}. See Details.}

\item{threshold}{A number between 0 and 1. Any
observation with a leverage value above this number is
declared a leverage point. This is automatically
determined unless \code{ttype = "custom"}.}

\item{...}{Additional arguments passed to the
\code{\link[graphics]{plot}} function.}

\item{text_arglist}{Additional arguments passed to the
\code{\link[graphics]{text}} function, which is used to
display the points that are identified.}

\item{abline_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{abline}}
function for the horizontal reference line added to the
plot.}

\item{extendrange_f}{Positive number(s) specifying the
fraction by which the range of the residuals should be
extended using the \code{\link[grDevices]{extendrange}}
function. If longer than one, \code{f[1]} is used on
the left and \code{f[2]} on the right.}
}
\description{
\code{leverage_plot} plots the leverage (hat) values from
the \code{\link[stats]{hatvalues}} function of a fitted
\code{lm} object.
}
\details{
If \code{ttype = "half"}, the threshold is \code{0.5}.

If \code{ttype = "2mean"}, the threshold is \eqn{2p/n},
where \eqn{p = }\code{length(stats::coef(model))} and
\eqn{n = }\code{stats::nobs(model)}, which is double the
mean leverage value.

If \code{ttype = "custom"} then the user must manually
specify \code{threshold}.
}
\examples{
lmod <- lm(price ~ sqft_living, data = home_sales)
# reference line not visible on plot because all
# leverage values are less than 0.5
leverage_plot(lmod, id_n = 2)
# different reference line
leverage_plot(lmod, id_n = 6, ttype = "2mean")
# custom reference line
leverage_plot(lmod, id_n = 2, ttype = "custom",
              threshold = 0.15)
}
\seealso{
\code{\link[graphics]{plot}},
  \code{\link[graphics]{text}},
  \code{\link[graphics]{abline}},
  \code{\link[stats]{rstudent}}
}
\author{
Joshua French
}
