% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_plot.lm.R
\name{residual_plot.lm}
\alias{residual_plot.lm}
\title{Plot residuals of a fitted \code{lm} object}
\usage{
\method{residual_plot}{lm}(
  model,
  rtype = c("ordinary", "standardized", "studentized", "loo", "jackknife", "deleted",
    "internally studentized", "externally studentized"),
  xaxis = "fitted",
  id_n = 3,
  predictors = ~.,
  smooth = stats::loess,
  add_reference = TRUE,
  add_smooth = TRUE,
  ...,
  text_arglist = list(),
  abline_arglist = list(),
  smooth_arglist = list(),
  lines_arglist = list(),
  extendrange_f = 0.08
)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{rtype}{The residual type to plot. The default is
\code{"ordinary"}. The other options are
\code{"standardized"}, \code{"studentized"},
\code{"loo"}, \code{"jackknife"}, \code{"deleted"},
\code{"internally studentized"}, \code{"externally
studentized"}.}

\item{xaxis}{The variable to use on the x-axis of the
plot(s). The default is \code{"fitted"} to use fitted
values. The other option is \code{"predictors"}.}

\item{id_n}{The number of points to identify with labels.
The default is \code{3}.}

\item{predictors}{A formula describing the first-order
predictors to plot the residuals against. The default
is all available first-order predictors.}

\item{smooth}{A function with a
\code{\link[stats]{formula}} argument to smooth the
desired plot. The default function is
\code{\link[stats]{loess}.}}

\item{add_reference}{A logical value indicating whether a
reference line should be added. The default is
\code{TRUE}.}

\item{add_smooth}{A logical value indicating whether a
smooth should be added to each plot produced. The
default is \code{TRUE}.}

\item{...}{Additional arguments passed to the
\code{\link[graphics]{plot}} function.}

\item{text_arglist}{Additional arguments passed to the
\code{\link[graphics]{text}} function, which is used to
display the points that are identified.}

\item{abline_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{abline}}
function for the horizontal reference line added to the
plot.}

\item{smooth_arglist}{A named list specifying additional
arguments passed to the function provided in the
\code{smooth} argument.}

\item{lines_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{lines}}
function for plotting the result of applying the
\code{smooth} function.}

\item{extendrange_f}{Positive number(s) specifying the
fraction by which the range of the residuals should be
extended using the \code{\link[grDevices]{extendrange}}
function. If longer than one, \code{f[1]} is used on
the left and \code{f[2]} on the right.}
}
\description{
\code{residual_plot.lm} plots the residuals of a fitted
\code{lm} object. In general, it is intended to provide
similar functionality to \code{\link[stats]{plot.lm}}
when \code{which = 1}, but can be used for different
types of residuals and can also plot first-order
predictor variables along the x-axis instead of only the
fitted values.\cr\cr Details about the different types of
residuals are discussed in the
\code{\link[api2lm]{get_residuals}} function.
}
\examples{
lmod <- lm(Petal.Length ~ Sepal.Length + Species,
           data = iris)
# similarity with built-in plot.lm functionality
residual_plot(lmod)
plot(lmod, which = 1)
# residual plot for other residual types
residual_plot(lmod, rtype = "standardized", id_n = 0)
# another residual plot with several customizations
residual_plot(lmod,
              text_arglist = list(col = "blue", cex = 2),
              abline_arglist = list(lwd = 2, lty = 2,
                                    col = "brown"),
              lines_arglist = list(col = "purple"),
              )
# residual plot for predictors
residual_plot(lmod, xaxis = "pred", id_n = 2)
# residual plot for individual predictors
residual_plot(lmod, xaxis = "pred",
              predictors = ~ Sepal.Length, id_n = 2)
residual_plot(lmod, xaxis = "pred",
              predictors = ~ Species,)
}
\seealso{
\code{\link[graphics]{plot}},
  \code{\link[graphics]{text}},
  \code{\link[graphics]{abline}},
  \code{\link[graphics]{lines}}
  \code{\link[stats]{loess}}.
}
\author{
Joshua French
}
