% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dom.R
\name{dom}
\alias{dom}
\title{Opvragen domeintabel}
\usage{
dom(naam, peildatum = Sys.Date())
}
\arguments{
\item{naam}{Naam van een domeintabel - De namen zijn niet hoofdlettergevoelig. Zie
\code{dom_overzicht()} voor geldige domeintabelnamen.}

\item{peildatum}{Date of een character die omgezet kan worden in een Date met
\code{lubridate::as_date()}. De peildatum filtert de output om alleen geldige
domeinwaarden op de peildatum weer te geven. Gebruik \code{NULL} om alle
domeinwaarden ongeacht de geldigheid weer te geven.}
}
\value{
Een tibble met een met domeinwaarden. De kolommen zijn afhankelijk
van de betreffende domeintabel.
}
\description{
Deze functie haalt een domeintabel op van www.aquo.nl.
}
\section{Caching}{
 Deze functie maakt gebruik van caching voor het
optimaliseren van snelheid en om de aquo-server niet onnodig te belasten.
Hiervoor wordt de map \code{tempdir()} gebruikt als cache. Deze map wordt na
elke R-sessie verwijderd.
}

\examples{
\dontrun{

dom("MonsterType")
dom("MonsterType", peildatum = Sys.Date())
dom("MonsterType", peildatum = "2021-04-05")

}
}
\seealso{
Other domeintabellen: 
\code{\link{dom_overzicht}()},
\code{\link{dom_save}()}
}
\concept{domeintabellen}
