% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portal-self.R
\name{self}
\alias{self}
\alias{arc_self_meta}
\alias{arc_portal_self}
\title{Access the Portal Self Resource}
\usage{
arc_self_meta(token = arc_token(), error_call = rlang::current_call())

arc_portal_self(token = arc_token(), error_call = rlang::current_call())
}
\arguments{
\item{token}{an object of class \code{httr2_token} as generated by \code{\link[=auth_code]{auth_code()}}
or related function}

\item{error_call}{the caller environment to be used when propagating errors.}
}
\value{
A named list.
}
\description{
The function returns the \href{https://developers.arcgis.com/rest/users-groups-and-items/portal-self.htm}{\verb{/self}} resource from the ArcGIS REST API. The \verb{/self} endpoint
returns the view of the portal as seen by the current user, whether anonymous
or signed in.
}
\details{
See the \href{https://developers.arcgis.com/rest/users-groups-and-items/portal-self.htm}{endpoint documentation} for more details.

The Portal Self response can vary based on whether it's called by a user, an app, or both.

The response includes user and appinfo properties, and the variations in responses are primarily related to these two properties. As the names indicate, the user property includes information about the user making the call, and the appinfo property includes information pertaining to the app that made the call.
}
\examples{
\dontrun{
set_arc_token(auth_code())
self <- arc_self_meta()
names(self)
}
}
\seealso{
Other portal: 
\code{\link{arc_portal_resources}()},
\code{\link{arc_portal_urls}()},
\code{\link{arc_portal_users}()}
}
\concept{portal}
