% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compact}
\alias{compact}
\alias{\%||\%}
\alias{check_dots_named}
\alias{data_frame}
\title{General utility functions}
\usage{
compact(.x)

a \%||\% b

check_dots_named(dots, call = rlang::caller_env())

data_frame(x, call = rlang::caller_call())
}
\arguments{
\item{.x}{a list}

\item{a}{an R object}

\item{b}{an R object}

\item{dots}{a list collected from dots via \code{rlang::list2(...)}}

\item{call}{default \code{\link[rlang:stack]{rlang::caller_call()}}.}

\item{x}{a data.frame}
}
\value{
\itemize{
\item \code{compact()} a list
\item \verb{\%||\%} the first non-null item or \code{NULL} if both are \code{NULL}
}
}
\description{
General utility functions
}
\details{
\itemize{
\item \code{compact()} removes any \code{NULL} list elements
\item \verb{\%||\%} is a special pipe operator that returns \code{b} if \code{a} is \code{NULL}
}
}
\examples{

# remove null elements
compact(list(a = NULL, b = 1))

# if NULL return rhs
NULL \%||\% 123

# if not NULL return lhs
123 \%||\% NULL

}
