% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_hypothesis_test.R
\name{argmin.HT}
\alias{argmin.HT}
\title{A wrapper to perform argmin hypothesis test.}
\usage{
argmin.HT(data, r = NULL, method = "softmin.LOO", ...)
}
\arguments{
\item{data}{(1) A n by p data matrix for (GTA); each of its row is a p-dimensional sample, or
(2) A n by (p-1) difference matrix for (SML, HML, NS, MT); each of its row is a (p-1)-dimensional sample differences}

\item{r}{The dimension of interest for hypothesis test; defaults to NULL. (Only needed for GTA)}

\item{method}{A string indicating the method for hypothesis test; defaults to 'softmin.LOO'. Passing an abbreviation is allowed.
For the list of supported methods and their abbreviations, see Details.}

\item{...}{Additional arguments to \link{argmin.HT.LOO}, \link{lambda.adaptive.enlarge}, \link{is.lambda.feasible.LOO}, \link{argmin.HT.MT}, \link{argmin.HT.gupta}.
A correct argument name needs to be specified if it is used.}
}
\value{
'Accept' or 'Reject'. A string indicating whether the given dimension could be an argmin (Accept) or not (Reject), and relevant statistics.
}
\description{
This is a wrapper to perform hypothesis test to see if a given dimension may be an argmin. Multiple methods are supported.
}
\details{
The supported methods include:\tabular{ll}{
   \code{softmin.LOO (SML)} \tab LOO (leave-one-out) algorithm, using the exponential weightings. Proposed by \insertRef{zhang2024winners}{argminCS}. \cr
   \tab \cr
   \code{argmin.LOO (HML)} \tab A variant of SML, but it uses (hard) argmin rather than exponential weighting.
   The method is not recommended because its type 1 error is not controlled. \cr
   \tab \cr
   \code{nonsplit (NS)} \tab  A variant of SML, but no splitting is involved.
   One needs to pass a fixed lambda value as a required additional argument.
   The method is not recommended because its type 1 error is not controlled. \cr
   \tab \cr
   \code{Bonferroni (MT)} \tab Multiple testing with Bonferroni's correction. \cr
   \tab \cr
   \code{Gupta (GTA)} \tab The method in \insertRef{gupta.1965}{argminCS}. \cr
}
}
\examples{
r <- 4
n <- 200
p <- 20
mu <- (1:p)/p
cov <- diag(length(mu))
set.seed(108)
data <- MASS::mvrnorm(n, mu, cov)
sample.mean <- colMeans(data)

## softmin.LOO
difference.matrix.r <- matrix(rep(data[,r], p-1), ncol=p-1, byrow=FALSE) - data[,-r]
argmin.HT(difference.matrix.r)

## use seed
argmin.HT(difference.matrix.r, seed=19)

# provide centered test statistic (to simulate asymptotic normality)
true.mean.difference.r <- mu[r] - mu[-r]
argmin.HT(difference.matrix.r, true.mean=true.mean.difference.r)

# keep the data unstandardized
argmin.HT(difference.matrix.r, scale.input=FALSE)

# use an user-specified lambda
argmin.HT(difference.matrix.r, lambda=sqrt(n)/2.5)

# add a seed
argmin.HT(difference.matrix.r, seed=19)

## argmin.LOO/hard min
argmin.HT(difference.matrix.r, method='HML')

## nonsplit
argmin.HT(difference.matrix.r, method='NS', lambda=sqrt(n)/2.5)

## Bonferroni (choose t test because of normal data)
argmin.HT(difference.matrix.r, method='MT', test='t')
## z test
argmin.HT(difference.matrix.r, method='MT', test='z')

## Gupta
critical.val <- get.quantile.gupta.selection(p=length(mu))
argmin.HT(data, r, method='GTA', critical.val=critical.val)

}
\references{
{
  \insertRef{zhang2024winners}{argminCS}

  \insertRef{cck.many.moments}{argminCS}

  \insertRef{gupta.1965}{argminCS}

  \insertRef{futschik.1995}{argminCS}
}
}
