% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arlc_clusters_plot.R
\name{arlc_clusters_plot}
\alias{arlc_clusters_plot}
\title{Plot Graph with Custom Layout and Communities}
\usage{
arlc_clusters_plot(g, graphLabel, clusters)
}
\arguments{
\item{g}{An igraph object representing the graph.}

\item{graphLabel}{A character string for the graph label to be displayed in the title.}

\item{clusters}{A list of clusters to highlight in the plot.}
}
\value{
The function produces a plot as a side effect.
}
\description{
This function plots a graph with specified aesthetics and highlights communities.
}
\examples{
\donttest{
library(arlclustering)
# Create a sample transactions dataset
sample_gml_file <- system.file("extdata", "karate.gml", package = "arlclustering")
g <- arlc_get_network_dataset(sample_gml_file, "Karate Club")
trans <- arlc_gen_transactions(g$graph)
supportRange <- seq(0.1, 0.2, by = 0.1)
Conf <- 0.5
params <- arlc_get_apriori_thresholds(trans, supportRange, Conf)
grossRules <- arlc_gen_gross_rules(trans, params$minSupp, params$minConf, 1, params$lenRules)
nonRR_rules <- arlc_get_NonR_rules(grossRules$GrossRules)
NonRRSig_rules <- arlc_get_significant_rules(trans, nonRR_rules$FiltredRules)
cleaned_rules <- arlc_clean_final_rules(NonRRSig_rules$FiltredRules)
clusters <- arlc_generate_clusters(cleaned_rules)
arlc_clusters_plot(g$graph, "Karate Club", clusters$Clusters)
}
}
