% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallOptionsOverStrikePrices.R
\name{CallOptionsOverStrikePrices}
\alias{CallOptionsOverStrikePrices}
\title{Call Option Values for Differently Priced European Call Options}
\usage{
CallOptionsOverStrikePrices(
  stock_data,
  future_time,
  buy_values,
  max.p = 5,
  max.q = 5,
  method = "CSS-ML"
)
}
\arguments{
\item{stock_data}{Numeric vector of stock prices data.}

\item{future_time}{Numeric constant of the future time}

\item{buy_values}{Numeric vector of the buy values at which to calculate the call option values}

\item{max.p}{The maximum order of the Auto Regressive part of the ARMA model (default is set to 5)}

\item{max.q}{The maximum order of the Moving Average part of the ARMA model (default is set to 5)}

\item{method}{The way that the ARMA model is calculated, accepted values are "ML", "CSS-ML" and "CSS"}
}
\value{
Estimated values of a European call option at different buy values
}
\description{
This function calculates the value of the a European call option for a list of strike price / buy values, given stock price data and a given future time.
}
\examples{
library(stats)
library(forecast)

# Create simulated data
n = 100
set.seed(42)
arma_values = arima.sim(n = n, model = list(ar = c(0.6), ma = c(0.5, -0.5)))
linear_model = 5 + 1:n
stock_data = arma_values + linear_model

future_time = 3
buy_values = seq(90, 110, length.out = 5)

CallOptionsOverStrikePrices(stock_data, future_time, buy_values)

}
