% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau_bound.R
\name{tau_bound}
\alias{tau_bound}
\title{tau_bound}
\usage{
tau_bound(v_list, complex, extremes = NULL, cores = 1, sumstat = "mean")
}
\arguments{
\item{v_list}{matrix or data frame of cartesian coordinates of vertices in
in point cloud}

\item{complex}{list of each vertex, edge, face, and (in 3D) tetrahedron in
a simplicial complex; same form as complex object in TDA package}

\item{extremes}{matrix or data frame of cartesian coordinates of vertices on
the boundary of the data frame. If no list given, function will
assume all points are extreme and check them all. Inclusion of
this parameter speeds up the process both within this function
and when calculating alpha because you will get a bigger (but
still valid) tau bound.}

\item{cores}{number of cores for parallelizing. Default 1.}

\item{sumstat}{string for summary statistic to be used to get final tau for
shape. Default is 'mean'. Options are 'median', 'min', and 'max'.}
}
\value{
tau_vec, vector real nonnegative number. Tau values for each point
}
\description{
This function finds the bound of tau for one shape, which is the maximum length of the
fiber bundle off of a shape for determining the density of points necessary
to recover the homology from the open cover. See Niyogi et al 2008. Function
checks length of edges and distances to circumcenters from each vertex before
checking against the rest of the point cloud and finds the minimum length.
We then keep the largest tau to account for the possibility of nonuniformity
among points.
}
