% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sideinfo_lib.R
\name{asus.cuts}
\alias{asus.cuts}
\title{Risk of asus with pre-defined grouping thresholds}
\usage{
asus.cuts(d, v.d, s, cutpoints)
}
\arguments{
\item{d}{an n vector of primary observations}

\item{v.d}{an n vector of variances for each component of d}

\item{s}{an n vector of side information}

\item{cutpoints}{k-1 pre-defined grouping thresholds for k groups. k must be bigger than 2.}
}
\value{
mse - estimate of risk
}
\description{
Estimates the risk of asus when there are k(>2) groups with pre-defined grouping thresholds
}
\details{
Estimates the risk of asus when there are k(>2) groups
    with k pre-defined grouping thresholds. This function is called when \code{\link{asus}}
    executes.
}
\examples{
library(asus)
set.seed(42)
d<-rnorm(10)
v.d<- rep(1,10)
set.seed(42)
s<-rnorm(10)
out<-asus.cuts(d,v.d,s,c(0.1,0.5,1))

}
\references{
Banerjee. T, Mukherjee. G and Sun. W. Adaptive Sparse Estimation with Side Information.
Journal of the American Statistical Association 115, no. 532 (2020): 2053-2067.
}
\seealso{
\code{\link{asus}},\code{\link{sureshrink}},\code{\link{ejs}},\code{\link{sureshrink.mse}}
}
