% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sideinfo_lib.R
\name{softTh}
\alias{softTh}
\title{Soft Thresholding estimator}
\usage{
softTh(y, thld)
}
\arguments{
\item{y}{1D signal to be thresholded}

\item{thld}{numeric threshold value}
}
\value{
a numeric vector of thresholded values of the same length as y.
}
\description{
Soft thresholds the input signal y with the threshold value thld
}
\examples{
library(asus)
set.seed(42)
y<-rnorm(10,2,1)
thld<- 3
x<-softTh(y,thld)

}
\references{
Donoho, David L. "De-noising by soft-thresholding."
IEEE transactions on information theory 41, no. 3 (1995): 613-627.
}
