% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso_classifier.R
\name{lasso_classifier}
\alias{lasso_classifier}
\title{Lasso classifier}
\usage{
lasso_classifier(
  L2.fix,
  L1.re,
  data.train,
  lambda,
  model.family,
  y,
  verbose = c(TRUE, FALSE)
)
}
\arguments{
\item{L2.fix}{Fixed effects. A two-sided linear formula describing
the fixed effects part of the model, with the outcome on the LHS and
the fixed effects separated by + operators on the RHS.}

\item{L1.re}{Random effects. A named list object, with the random effects
providing the names of the list elements and ~ 1 being the list elements.}

\item{data.train}{Training data. A data.frame containing the training data
used to train the model.}

\item{lambda}{Tuning parameter. Lambda is the penalty parameter that controls
the shrinkage of fixed effects.}

\item{model.family}{Model family. A variable indicating the model family
to be used by glmmLasso. Defaults to binomial(link = "probit").}

\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable. A character scalar containing the column name of
the outcome variable in \code{survey}.}

\item{verbose}{Verbose output. A logical vector indicating whether or not
verbose output should be printed.}
}
\value{
A multilevel lasso model. An \code{\link[glmmLasso]{glmmLasso}}
  object.
}
\description{
\code{lasso_classifier} applies lasso classification to a data set.
}
