% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelPlot.R
\name{modelPlot}
\alias{modelPlot}
\title{Draw coefficients/odds ratio/hazard ratio plot}
\usage{
modelPlot(
  fit,
  widths = NULL,
  change.pointsize = TRUE,
  show.OR = TRUE,
  show.ref = TRUE,
  bw = TRUE,
  legend.position = "top",
  ...
)
}
\arguments{
\item{fit}{An object of class glm}

\item{widths}{Numeric vector}

\item{change.pointsize}{logical Whether or not change point size}

\item{show.OR}{logical Whether or not show odds ratio}

\item{show.ref}{logical Whether or not show reference}

\item{bw}{logical If true, use grey scale}

\item{legend.position}{legend position default value is 'top'}

\item{...}{Further arguments to be passed to autoReg()}
}
\value{
modelPlot returns an  object of class "modelPlot"
An object of class modelPlot is a list containing at least of the following components:
\describe{
   \item{tab1}{The first table containing names}
   \item{tab2}{The 2nd table containing levels}
   \item{tab3}{The 3rd table containing coefficients or odds ratio or hazards ratio}
   \item{p}{A ggplot}
   \item{widths}{the widths of the tables and the ggplot}
}
}
\description{
Draw coefficients/odds ratio/hazard ratio plot
}
\examples{
fit=lm(mpg~wt*hp+am,data=mtcars)
modelPlot(fit,widths=c(1,0,2,3))
modelPlot(fit,uni=TRUE,threshold=1,widths=c(1,0,2,3))
fit=lm(Sepal.Width~Sepal.Length*Species,data=iris)
modelPlot(fit)
modelPlot(fit,uni=TRUE,change.pointsize=FALSE)
\donttest{
data(cancer,package="survival")
fit=glm(status~rx+age+sex+nodes+obstruct+perfor,data=colon,family="binomial")
modelPlot(fit)
modelPlot(fit,uni=TRUE,multi=TRUE,threshold=1)
modelPlot(fit,multi=TRUE,imputed=TRUE,change.pointsize=FALSE)
data(colon_s,package="finalfit")
fit=glm(mort_5yr~age.factor+sex.factor+obstruct.factor+perfor.factor,data=colon_s,family="binomial")
modelPlot(fit)
modelPlot(fit,uni=TRUE,multi=TRUE,threshold=1)
modelPlot(fit,uni=TRUE,multi=TRUE)
modelPlot(fit,uni=TRUE,multi=TRUE,threshold=1,show.ref=FALSE)
library(survival)
fit=coxph(Surv(time,status)~rx+age+sex+obstruct+perfor,data=colon)
modelPlot(fit)
modelPlot(fit,uni=TRUE,threshold=1)
modelPlot(fit,multi=FALSE,final=TRUE,threshold=1)
fit=coxph(Surv(time,status)~age.factor+sex.factor+obstruct.factor+perfor.factor,data=colon_s)
modelPlot(fit)
modelPlot(fit,uni=TRUE,threshold=1)
modelPlot(fit,uni=TRUE,threshold=1,show.ref=FALSE)
modelPlot(fit,imputed=TRUE)
}
}
