% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autogam.R
\name{autogam}
\alias{autogam}
\title{Automate the creation of a Generalized Additive Model (GAM)}
\usage{
autogam(data, y_col, ..., bs = "cr")
}
\arguments{
\item{data}{dataframe. All the variables in \code{data} will be used to predict \code{y_col}. To exclude any variables, assign as \code{data} only the subset of variables desired.}

\item{y_col}{character(1). Name of the y outcome variable.}

\item{...}{Arguments passed on to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{bs}{character(1). The default basis function for GAM smooths. See \code{?mgcv::smooth.terms} for details. Whereas the default \code{bs} in \code{mgcv} is 'tp', \code{autogam}'s default is 'cr', which is much faster and comparably accurate.}
}
\value{
Returns an \code{mgcv::gam} object, the result of predicting \code{y_col} from all other variables in \code{data}.
}
\description{
\code{autogam()} is a wrapper for 'mgcv::gam()' that makes it easier to create high-performing Generalized Additive Models (GAMs). By entering just a dataset and the name of the outcome column as inputs, \code{autogam()} tries to automate the procedure of configuring a highly accurate GAM which performs at reasonably high speed, even for large datasets.
}
\examples{
autogam(mtcars, 'mpg')

}
