% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_keys}
\alias{am_keys}
\title{Get all keys from an Automerge map}
\usage{
am_keys(doc, obj)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID (must be a map), or \code{AM_ROOT}
for the document root}
}
\value{
Character vector of keys (empty if map is empty)
}
\description{
Returns a character vector of all keys in a map.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "a", 1)
am_put(doc, AM_ROOT, "b", 2)

keys <- am_keys(doc, AM_ROOT)
keys  # c("a", "b")
}
