% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$feature_pca}
\alias{AUTO_VI$feature_pca}
\title{Conduct principal component analysis for features extracted from keras model}
\arguments{
\item{feature}{Dataframe. A data frame where columns represent
features and rows represent observations. It should have only one row.}

\item{null_feature}{Dataframe. A data frame where columns represent
features and rows represent observations. These features are extracted
during the evaluation of null plots.}

\item{boot_feature}{Dataframe. A data frame where columns represent
features and rows represent observations. These features are extracted
during the evaluation of bootstrapped plots.}

\item{center}{Boolean. Whether to subtract the mean from the feature.}

\item{scale}{Boolean. Whether to divide the feature by its standard
deviation.}

\item{pattern}{Character. A regrex pattern to search for features in the
provided DataFrame. See also \code{\link[=grep]{grep()}}.}
}
\value{
A tibble of the raw features and the rotated features with
attributes \code{sdev} and \code{rotation} representing the
standard deviation of the principal
components and the rotation matrix respectively.
}
\description{
This function conducts principal component analysis for
features extracted from keras model.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$feature_pca(
  feature = self$check_result$observed,
  null_feature = self$check_result$null,
  boot_feature = self$check_result$boot,
  center = TRUE,
  scale = TRUE,
  pattern = "^f_.*$"
)
}\if{html}{\out{</div>}}
}
}
\details{
Features need to be extracted while running the method
\code{\link[=AUTO_VI$check]{AUTO_VI$check()}} and \code{\link[=AUTO_VI$lineup_check]{AUTO_VI$lineup_check()}} by providing the argument
\code{extract_feature_from_layer}. Features with zero variance will be ignored
from the analysis. See also \code{\link[stats:prcomp]{stats::prcomp()}}. By default, features are
assumed to follow the naming convention
"f_(index)", where index is from one to the number of features.
}
\examples{
keras_model <- try(get_keras_model("vss_phn_32"))
if (!inherits(keras_model, "try-error")) {
  myvi <- auto_vi(lm(dist ~ speed, data = cars), keras_model)

  myvi$lineup_check(extract_feature_from_layer = "global_max_pooling2d")
  myvi$feature_pca()
}

}
