% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_org_into_seq.R
\name{convert_org_into_seq}
\alias{convert_org_into_seq}
\title{Converts a genome instruction sequence into a digital organism file}
\usage{
convert_org_into_seq(
  org,
  inst_set = "heads",
  save = FALSE,
  file_name = NULL,
  save_path = getwd(),
  format = "seq",
  silent = FALSE
)
}
\arguments{
\item{org}{Data Frame. Column names: \code{instruction}.}

\item{inst_set}{Name of the instruction set. It must be one of the
following: \code{heads} (default), \code{heads-sex}", or \code{transsmt}. The names
correspond to the instruction set configuration files (e.g.,
\code{instset-heads.cfg} for \code{heads}.}

\item{save}{Logical value (TRUE/FALSE) indicating whether the output should
or should not be saved to a file ("FALSE" by default).}

\item{file_name}{String of characters representing the name of the file
without any extension ("genome.seq" by default).}

\item{save_path}{String of characters representing the name of the folder
where the digital organism file will be saved.}

\item{format}{String of characters representing the format of the file
("seq" by default).}

\item{silent}{Logical value (TRUE/FALSE) to show/hide messages
("FALSE" by default).}
}
\value{
String of characters.
}
\description{
Converts a digital organism instruction set into a digital
genome instruction sequence.
}
\examples{

# Create triplestore object
avidaDB <- triplestore_access$new()

# Set access options
avidaDB$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

sequence <- get_genome_seq_from_genome_id(
  genome_id = 1,
  triplestore = avidaDB
)$genome_seq[[1]]

convert_seq_into_org(genome_seq = sequence)

}
