% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{create_tabular_dataset_from_sql_query}
\alias{create_tabular_dataset_from_sql_query}
\title{Create a TabularDataset to represent tabular data in SQL databases.}
\usage{
create_tabular_dataset_from_sql_query(
  query,
  validate = TRUE,
  set_column_types = NULL,
  query_timeout = 30L
)
}
\arguments{
\item{query}{A SQL-kind datastore and a query}

\item{validate}{Boolean to validate if data can be loaded from the returned dataset.
Defaults to True. Validation requires that the data source is accessible from
the current compute.}

\item{set_column_types}{A named list to set column data type, where key is
column name and value is data type.}

\item{query_timeout}{Sets the wait time (as an int, in seconds) before terminating the attempt to execute a command
and generating an error. The default is 30 seconds.}
}
\value{
A \code{TabularDataset} object
}
\description{
Create a TabularDataset to represent tabular data in SQL databases.
``from_sql_query``` creates a Tabular Dataset object , which defines the operations to
load data from SQL databases into tabular representation. For the data to be accessible
by Azure Machine Learning, the SQL database specified by \code{query} must be located in
a Datastore and the datastore type must be of a SQL kind. Column data types are
read from data types in SQL query result. Providing `set_column_types` will
override the data type  for the specified columns in the returned Tabular Dataset.
}
\section{Examples}{
\preformatted{# create tabular dataset from a SQL database in datastore
datastore <- get_datastore(ws, 'sql-db')
query <- data_path(datastore, 'SELECT * FROM my_table')
tab_ds <- create_tabular_dataset_from_sql_query(query, query_timeout = 10)

# use `set_column_types` param to set column data types
data_types <- list(ID = data_type_string(),
                   Date = data_type_datetime('\%d/\%m/\%Y \%I:\%M:\%S \%p'),
                   Count = data_type_long(),
                   Latitude = data_type_double(),
                   Found = data_type_bool())

set_tab_ds <- create_tabular_dataset_from_sql_query(query, set_column_types = data_types)
}
}

\seealso{
\code{\link[=data_path]{data_path()}} \code{\link[=data_type_datetime]{data_type_datetime()}} \code{\link[=data_type_bool]{data_type_bool()}}
\code{\link[=data_type_double]{data_type_double()}} \code{\link[=data_type_string]{data_type_string()}} \code{\link[=data_type_long]{data_type_long()}}
}
