% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_create.R, R/config_default.R
\name{create_config}
\alias{create_config}
\alias{create_docker_config}
\alias{create_singularity_config}
\alias{get_default_config}
\alias{set_default_config}
\title{Backend configuration for containerisation}
\usage{
create_config(
  backend = get_env_or_null("BABELWHALE_BACKEND") \%||\% detect_backend()
)

create_docker_config(environment_variables = character(0))

create_singularity_config(
  cache_dir = get_env_or_null("SINGULARITY_CACHEDIR") \%||\%
    get_env_or_null("APPTAINER_CACHEDIR") \%||\% ".singularity/",
  environment_variables = character(0)
)

get_default_config()

set_default_config(config, permanent = TRUE)
}
\arguments{
\item{backend}{Which backend to use. Can be either \code{"docker"} or \code{"singularity"}.}

\item{environment_variables}{A character vector of environment variables. Format: \code{c("ENVVAR=VALUE")}.}

\item{cache_dir}{A folder in which to store the singularity images. A container typically requires 100MB to 2GB.}

\item{config}{A config to save as default.}

\item{permanent}{Whether or not to save the config file permanently}
}
\description{
It is advised to define the \code{"BABELWHALE_BACKEND"} environment variable as \code{"docker"} or \code{"singularity"}.

When using singularity, also define the \code{"SINGULARITY_CACHEDIR"} environment variable,
which is the folder where the singularity images will be cached.

When using apptainer, also define the \code{"APPTAINER_CACHEDIR"} environment variable,
which is the folder where the singularity images will be cached.

Each TI method will require about 1GB of space.

Alternatively, you can create a config and save it using \code{set_default_config()}.
}
\examples{
config <- create_docker_config()
set_default_config(config, permanent = FALSE)

config <- create_singularity_config(
  # ideally, this would be set to a non-temporary directory
  cache_dir = tempdir()
)
set_default_config(config, permanent = FALSE)

}
