% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_dispersion_field_distribution.R
\name{null_dispersion_field_distribution}
\alias{null_dispersion_field_distribution}
\title{null_dispersion_field_distribution: Null distribution of the
dispersion field}
\usage{
null_dispersion_field_distribution(
  pam,
  n_iter = 10,
  randal = "indep_swap",
  parallel = TRUE,
  n_cores = 2
)
}
\arguments{
\item{pam}{A Presence-Absence-Matrix of matrix class or sparse matrix.}

\item{n_iter}{Number of iterations to obtain the distribution.}

\item{randal}{Randomization algorithm applied to the PAM.
Possible choices "curveball", "fastball", and "indep_swap".}

\item{parallel}{If TRUE the computations will be performed in parallel.}

\item{n_cores}{Number of cores for the parallel computation.}
}
\value{
A data matrix of size nrow(pam) X n_iter with dispersion
field values.
}
\description{
null_dispersion_field_distribution estimates a
random distribution of the dispersion field values.
}
\details{
Estimates a random distribution of the dispersion field values. To obtain
         random values it uses the function \code{\link[bamm]{permute_pam}}
         at each step of the iterations. Randomization of the PAM can be
         performed using the "fastball" (Godard and Neal, 2022) and the
         "curveball" (Strona et al., 2014), and  and the independent
         swap (Kembel et al. 2010) algorithms.
         The implementation of the "fastball" in C++ is provided
         in \url{https://github.com/zpneal/fastball/blob/main/fastball.cpp}
}
\examples{
set.seed(111)
pam <- matrix(rbinom(100,1,0.3),nrow = 10,ncol = 10)
dfield_rand <- bamm::null_dispersion_field_distribution(pam,n_iter=10,
                                                       parallel=FALSE,
                                                       randal="indep_swap",
                                                       n_cores = 2)
head(dfield_rand)
}
\references{
\insertRef{Soberon2015}{bamm}

\insertRef{Strona2014}{bamm}

\insertRef{Gordard2022}{bamm}

\insertRef{Kembel2010}{bamm}
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
