% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6.ord_vectors.R
\name{ord_vectors}
\alias{ord_vectors}
\title{Extract significant environmental vectors from vegan ordination object}
\usage{
ord_vectors(
  ord,
  data,
  p_thresh = 0.05,
  filter = c("significant", "nonsignificant", "all")
)
}
\arguments{
\item{ord}{Vegan ordination object (e.g., rda, cca).}

\item{data}{Environmental variables data frame used for envfit.}

\item{p_thresh}{P-value threshold to determine significance (default 0.05).}

\item{filter}{Character; one of "significant" (default), "nonsignificant", or "all".}
}
\value{
Data frame of vectors with scores, p-values, and labels.
}
\description{
Performs an envfit analysis and returns environmental vectors with p-values,
filtered by significance or unfiltered.
}
