% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_cox.R
\name{stratified_boxcox}
\alias{stratified_boxcox}
\title{Box-Cox transformation for stratified data}
\usage{
stratified_boxcox(
  data,
  value_col,
  strat_cols,
  plot = FALSE,
  return = "values",
  buffer = 0,
  inverse = FALSE,
  lambdas = NULL
)
}
\arguments{
\item{data}{data.frame containing the data}

\item{value_col}{character, name of column with values to be transformed}

\item{strat_cols}{character (vector), name(s) of columns to stratify by}

\item{plot}{logical, should the lambda distribution be plotted?}

\item{return}{character, either "values" or "lambdas"}

\item{buffer}{numeric, buffer value to be added before transformation, used to ensure all positive values}

\item{inverse}{logical, if TRUE, the function reverses the transformation given a list of lambdas}

\item{lambdas}{if inverse == TRUE: Nested list of lambdas used in original transformation. Can be obtained by using return = "lambdas" on untransformed data}
}
\value{
if "values", vector of transformed values, if "lambdas" nested named list of used lambdas. The buffer will be equal for all strata
}
\description{
Create Box-Cox transformation using different optimal lambda values for each stratum
}
\examples{
data <- data.frame("value" = c(1:50, rnorm(50, 100, 10)),
                   "strat_var" = rep(c(1,2), each = 50),
                   "strat_var2" = rep(c(1, 2), 50))
lambdas <- stratified_boxcox(data = data, value_col = "value",
                             strat_cols = c("strat_var", "strat_var2"),
                             return = "lambdas")
data$value_boxed <- stratified_boxcox(data = data, value_col = "value",
                                      strat_cols = c("strat_var", "strat_var2"),
                                      return = "values")
data$value_unboxed <- stratified_boxcox(data = data, value_col = "value_boxed",
                                        strat_cols = c("strat_var", "strat_var2"),
                                        inverse = TRUE, lambdas = lambdas)

}
\author{
J. Peter Marquardt
}
