% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{output_paths}
\alias{output_paths}
\title{Generate modified file paths by adding prefixes and/or suffixes}
\usage{
output_paths(paths, prefix = "", suffix = "_new", dir = NULL)
}
\arguments{
\item{paths}{A character vector of file paths to modify}

\item{prefix}{A character string to add at the beginning of each filename.
Default is the empty sting \code{""}.}

\item{suffix}{A character string to add at the end of each filename, before the extension.
Default is \code{"_new"}.}

\item{dir}{An optional character string specifying the output directory.
If provided, the modified filenames will be placed in this directory.
This is useful if \code{paths} are relative and a different output directory is required.
Default is \code{NULL}.}
}
\value{
A character vector of modified file paths with the specified prefixes and suffixes.
The original paths are preserved as names of the returned vector.
}
\description{
This function takes a vector of file paths and returns a vector of modified paths
with prefixes and/or suffixes added to the filenames. It's useful for generating
output paths for the \code{convert_files()} and \code{convert_dir()} functions.
\code{files_to_convert()} is useful for generating the input \code{paths}.
}
\examples{
# Get all convertible files from examples directory
input_files <- files_to_convert(example_dir())

# Generate output paths with "_converted" suffix
output_paths(input_files, suffix = "_converted")

# Add both prefix and suffix and place in a new directory
output_paths(
  input_files,
  prefix = "base_",
  suffix = "_converted",
  dir = "~/new_dir"
)

}
\seealso{
\code{\link[=convert_files]{convert_files()}}, \code{\link[=files_to_convert]{files_to_convert()}}
}
