% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{batsch}
\alias{batsch}
\alias{SLC6A14r}
\alias{SLC22A13h}
\alias{EMTp}
\alias{ETTch}
\alias{GAPDHh}
\title{qPCR data sets by Batsch et al. (2008)}
\format{
Each data set is provided as a \link[tibble:tibble-package]{tibble} with
675 rows and 9 variables:
\describe{
\item{\code{plate}}{Plate identifier. Because one plate was used per target, the
name of the plate is the same as the values in \code{target}.}
\item{\code{well}}{Well identifier. Values are always \code{NA} (not available) for
these data sets. This variable is kept nevertheless to be coherent with other
data sets from other similar R data packages.}
\item{\code{dye}}{Either SYBR Green I master mix (Roche) (\code{"SYBR"}) or TaqMan
probe (\code{"TaqMan"}).}
\item{\code{target}}{Target identifier: rat SLC6A14 (\code{"SLC6A14r"}), human SLC22A13
(\code{"SLC22A13h"}), pig EMT (\code{"EMTp"}), chicken ETT (\code{"ETTch"}) or human GAPDH
(\code{"GAPDHh"}).}
\item{\code{sample_type}}{Sample type (all curves are standards, i.e. \code{"std"}).}
\item{\code{replicate}}{Replicate identifier: 1 thru 3.}
\item{\code{dilution}}{Dilution factor. Higher number means greater dilution.}
\item{\code{cycle}}{PCR cycle.}
\item{\code{fluor}}{Raw fluorescence values.}
}
}
\source{
\doi{10.1186/1471-2105-9-95}
}
\usage{
SLC6A14r

SLC22A13h

EMTp

ETTch

GAPDHh
}
\description{
Each data set comprises a five-point, four-fold dilution series. For each
concentration there are three replicates. Each amplification curve is 45
cycles long.

A single reaction (total volume 10 µl) contained 1 µl master mix (LightCycler
TaqMan Master; Roche 04735536001), 1 µmol/l each of forward and reverse
primer, SYBR Green I at 1:30 dilution (Invitrogen S7563) or 50 nmol/l probe,
and various amounts of cDNA or plasmid DNA. Contamination controls contained
water instead of DNA. After enzyme activation (10 min, 95°C), thermocycling
consisted of 45 cycles of 10 s at 95°C, 30 s at 55°C, and 1 s at 72°C;
velocity of temperature change was 1.1°C/s.
Please read the Methods section of Batsch et al. (2008) for more details.
}
\examples{
SLC6A14r

SLC22A13h

EMTp

ETTch

GAPDHh

}
\keyword{datasets}
