% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bcfrailph.R
\name{plot.bcfrailph}
\alias{plot.bcfrailph}
\title{Plot bcfrailph}
\usage{
\method{plot}{bcfrailph}(
  x,
  lty = 1,
  col = 1,
  type = "l",
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  main = NULL,
  conf.int = FALSE,
  ...
)
}
\arguments{
\item{x}{A class \code{bcfrailph} object.}

\item{lty}{Line type line type 1 is a solid line (the default).}

\item{col}{Colors to be used for points.}

\item{type}{The type of plot produced. type="l" Plot lines (the default) and type="p" Plot individual points.}

\item{xlim}{range of variable on the x axis.}

\item{ylim}{range of variable on the y axis.}

\item{xlab}{Axis label for the x axis.}

\item{main}{main is a string for figure title, placed at the top of the plot in a large font.}

\item{conf.int}{whether confidence interval is included in the plot the deafault is FALSE.}

\item{...}{ignored}
}
\value{
An plot of  \code{plot.bcfrailph} object.
}
\description{
Generics to print the S3 class bcfrailph.
}
\details{
Calls \code{plot.bcfrailph()}.
}
\note{
The plot of cumulative baseline hazard function.
}
\examples{
set.seed(24)
simdata<-simbcfrail(psize=100, cenr= c(0),beta=c(-1),frailty=c("gamma"),
frailpar=c(0.4,0.5),bhaz=c("weibull"),
bhazpar=list(shape =c(0.9), scale = c(2)),
covartype= c("B"),covarpar=list(fargs=c(1),sargs=c(0.5)))
dataa<-simdata$data ## the generated data set.

#fit
bcfit=bcfrailph(Surv(time, censor) ~ X1+frailty(PID),data=dataa)
plot(bcfit)

}
\seealso{
\code{\link{bcfrailph}}
}
