% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorYtbid.R
\name{ExtractorYtbid}
\alias{ExtractorYtbid}
\title{Class to handle comments of YouTube files with ytbid extension}
\description{
This class inherits from the \code{\link{Instance}} class and
implements the functions of extracting the text and the date of an ytbid type file.
}
\section{Details}{

YouTube connection is handled through the \code{\link{Connections}} class
which loads the YouTube API credentials from the \emph{{bdpar.Options}} object.
Additionally, to increase the processing speed, each Youtube query is stored
in a cache to avoid the execution of duplicated queries. To enable this option,
cache location should be in the \strong{"cache.youtube.path"} field of
\emph{\link{bdpar.Options}} variable. This variable has to be the
path to store the comments and it is necessary that it has two folder named:
"_spam_" and "_ham_"
}

\section{Inherit}{

This class inherits from \code{\link{Instance}} and implements the
\code{obtainSource} and \code{obtainDate} abstracts functions.
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{Connections}},
         \code{\link{ExtractorEml}}, \code{\link{ExtractorSms}},
         \code{\link{Instance}}
}
\section{Super class}{
\code{\link[bdpar:Instance]{bdpar::Instance}} -> \code{ExtractorYtbid}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtractorYtbid-new}{\code{ExtractorYtbid$new()}}
\item \href{#method-ExtractorYtbid-obtainId}{\code{ExtractorYtbid$obtainId()}}
\item \href{#method-ExtractorYtbid-getId}{\code{ExtractorYtbid$getId()}}
\item \href{#method-ExtractorYtbid-obtainDate}{\code{ExtractorYtbid$obtainDate()}}
\item \href{#method-ExtractorYtbid-obtainSource}{\code{ExtractorYtbid$obtainSource()}}
\item \href{#method-ExtractorYtbid-toString}{\code{ExtractorYtbid$toString()}}
\item \href{#method-ExtractorYtbid-clone}{\code{ExtractorYtbid$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addBanPipes"><a href='../../bdpar/html/Instance.html#method-Instance-addBanPipes'><code>bdpar::Instance$addBanPipes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addFlowPipes"><a href='../../bdpar/html/Instance.html#method-Instance-addFlowPipes'><code>bdpar::Instance$addFlowPipes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addProperties"><a href='../../bdpar/html/Instance.html#method-Instance-addProperties'><code>bdpar::Instance$addProperties()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="checkCompatibility"><a href='../../bdpar/html/Instance.html#method-Instance-checkCompatibility'><code>bdpar::Instance$checkCompatibility()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getBanPipes"><a href='../../bdpar/html/Instance.html#method-Instance-getBanPipes'><code>bdpar::Instance$getBanPipes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getData"><a href='../../bdpar/html/Instance.html#method-Instance-getData'><code>bdpar::Instance$getData()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getDate"><a href='../../bdpar/html/Instance.html#method-Instance-getDate'><code>bdpar::Instance$getDate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getFlowPipes"><a href='../../bdpar/html/Instance.html#method-Instance-getFlowPipes'><code>bdpar::Instance$getFlowPipes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getNamesOfProperties"><a href='../../bdpar/html/Instance.html#method-Instance-getNamesOfProperties'><code>bdpar::Instance$getNamesOfProperties()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getPath"><a href='../../bdpar/html/Instance.html#method-Instance-getPath'><code>bdpar::Instance$getPath()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getProperties"><a href='../../bdpar/html/Instance.html#method-Instance-getProperties'><code>bdpar::Instance$getProperties()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSource"><a href='../../bdpar/html/Instance.html#method-Instance-getSource'><code>bdpar::Instance$getSource()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSpecificProperty"><a href='../../bdpar/html/Instance.html#method-Instance-getSpecificProperty'><code>bdpar::Instance$getSpecificProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="invalidate"><a href='../../bdpar/html/Instance.html#method-Instance-invalidate'><code>bdpar::Instance$invalidate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isInstanceValid"><a href='../../bdpar/html/Instance.html#method-Instance-isInstanceValid'><code>bdpar::Instance$isInstanceValid()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isSpecificProperty"><a href='../../bdpar/html/Instance.html#method-Instance-isSpecificProperty'><code>bdpar::Instance$isSpecificProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setData"><a href='../../bdpar/html/Instance.html#method-Instance-setData'><code>bdpar::Instance$setData()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setDate"><a href='../../bdpar/html/Instance.html#method-Instance-setDate'><code>bdpar::Instance$setDate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setProperties"><a href='../../bdpar/html/Instance.html#method-Instance-setProperties'><code>bdpar::Instance$setProperties()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSource"><a href='../../bdpar/html/Instance.html#method-Instance-setSource'><code>bdpar::Instance$setSource()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSpecificProperty"><a href='../../bdpar/html/Instance.html#method-Instance-setSpecificProperty'><code>bdpar::Instance$setSpecificProperty()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorYtbid-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorYtbid-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ExtractorYtbid}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$new(path, cachePath = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. Path of the ytbid file.}

\item{\code{cachePath}}{A \code{\link{character}} value. Path of the cache
location. If it is NULL, checks if is defined in the
\strong{"cache.youtube.path"} field of \code{\link{bdpar.Options}}
variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorYtbid-obtainId"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorYtbid-obtainId}{}}}
\subsection{Method \code{obtainId()}}{
Obtains the ID of the specific Youtube's comment. Reads the ID
of the file indicated in the variable path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$obtainId()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorYtbid-getId"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorYtbid-getId}{}}}
\subsection{Method \code{getId()}}{
Gets the ID of an specific Youtube's comment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$getId()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of Youtube's comment ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorYtbid-obtainDate"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorYtbid-obtainDate}{}}}
\subsection{Method \code{obtainDate()}}{
Obtains the date from a specific comment ID. If the comment
has been previously cached the comment date is loaded from cache path.
Otherwise, the request is perfomed using YouTube API and the date is then
formatted to the established standard.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$obtainDate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorYtbid-obtainSource"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorYtbid-obtainSource}{}}}
\subsection{Method \code{obtainSource()}}{
Obtains the source from a specific comment ID. If the
comment has previously been cached the source is loaded from cache path.
Otherwise, the request is performed using on YouTube API.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$obtainSource()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorYtbid-toString"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorYtbid-toString}{}}}
\subsection{Method \code{toString()}}{
Returns a \code{\link{character}} representing the instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$toString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link{Instance}} \code{\link{character}} representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorYtbid-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorYtbid-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorYtbid$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
