% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sem_C_matrix}
\alias{sem_C_matrix}
\title{Coefficients matrix for initial conditions}
\usage{
sem_C_matrix(alpha, phi_0, periods_n, beta = NULL, phi_1 = NULL)
}
\arguments{
\item{alpha}{numeric}

\item{phi_0}{numeric}

\item{periods_n}{numeric}

\item{beta}{numeric vector. Default is c() for no regressors case.}

\item{phi_1}{numeric vector. Default is c() for no regressors case.}
}
\value{
matrix
}
\description{
Create matrix for Simultaneous Equations Model (SEM)
representation with coefficients placed next to initial values
of regressors, dependent variable and country-specific time-invariant
variables.
}
\examples{
alpha <- 9
phi_0 <- 19
beta <- 11:15
phi_1 <- 21:25
periods_n <- 4
sem_C_matrix(alpha, phi_0, periods_n, beta, phi_1)
}
