% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{ExtraF}
\alias{ExtraF}
\title{ExtraF}
\usage{
ExtraF(
  dat,
  equation = "hs",
  groups = NULL,
  verbose = FALSE,
  k,
  compare = "alpha",
  idcol = "id",
  xcol = "x",
  ycol = "y",
  groupcol = NULL,
  start_alpha = 0.001
)
}
\arguments{
\item{dat}{Long form data frame}

\item{equation}{"hs"}

\item{groups}{NULL for all. Character vector matching groups in groupcol}

\item{verbose}{If TRUE, prints all output including models}

\item{k}{User-defined k value; if missing will attempt to find shared k and then mean emprirical range (in log units)}

\item{compare}{Specify whether to compare alpha or Q0. Default is alpha}

\item{idcol}{The column name that should be treated as dataset identifier}

\item{xcol}{The column name that should be treated as "x" data}

\item{ycol}{The column name that should be treated as "y" data}

\item{groupcol}{The column name that should be treated as the groups}

\item{start_alpha}{Optional numeric to inform starting value for alpha}
}
\value{
List of results and models
}
\description{
Extra Sum of Squares F-test
}
\details{
One alpha better than individual alphas?
}
\examples{
## Compare two groups using equation by Koffarnus et al., 2015 and a fixed k of 2
\donttest{
apt$group <- NA
apt[apt$id \%in\% sample(unique(apt$id), length(unique(apt$id))/2), "group"] <- "a"
apt$group[is.na(apt$group)] <- "b"
ExtraF(apt, "koff", k = 2, groupcol = "group")
}
}
\author{
Brent Kaplan <bkaplan.ku@gmail.com>
}
