% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood_inference.R
\name{bets.likelihood}
\alias{bets.likelihood}
\title{(Profile) Likelihood function}
\usage{
bets.likelihood(
  params,
  data,
  likelihood = c("conditional", "unconditional"),
  M = Inf,
  r = NULL,
  L = NULL,
  params_init = NULL
)
}
\arguments{
\item{params}{A vector of parameters (with at least one of the following entries: rho, r, ip_q50, ip_q95)}

\item{data}{A data frame with three columns: B, E, S}

\item{likelihood}{Use the conditional or unconditional likelihood function}

\item{M}{Right truncation for symptom onset}

\item{r}{Parameter for epidemic growth (overrides \code{{params}})}

\item{L}{Day of travel quarantine}

\item{params_init}{Initial parameters for computing the profile likelihood}
}
\value{
Log-likelihood function if \code{params} has all four entries, rho, r, ip_q50, ip_q95 (or three entires---r, ip_q50, ip_q95---if computing the conditional likelihood). Otherwise returns the profile likelihood for the parameters in \code{params}.
}
\description{
(Profile) Likelihood function
}
\details{
Non-default values of \code{M} and \code{r} are only available for conditional likelihood.
}
\examples{

data(wuhan_exported)

data <- wuhan_exported
data$B <- data$B - 0.75
data$E <- data$E - 0.25
data$S <- data$S - 0.5

params <- c(r = 0.2,
            ip_q50 = 5,
            ip_q95 = 12)

# Conditional likelihood
bets.likelihood(params, data)

# Conditional likelihood with right truncation
bets.likelihood(params, subset(data, S <= 60), M = 60)

# Conditional likelihood with fixed r (not recommended)
bets.likelihood(params, data, r = 0)

# Unconditional likelihood
params["rho"] <- 1
bets.likelihood(params, data, likelihood = "unconditional", L = 54)

# Profile conditional likelihood
bets.likelihood(c(r = 0.2), data, params_init = params)

}
