% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{getPosteriorModeAutosomalTrisomy}
\alias{getPosteriorModeAutosomalTrisomy}
\title{Getting the posterior mode for each autosomal trisomy}
\usage{
getPosteriorModeAutosomalTrisomy(
  object,
  scaffoldName,
  threshold_certainty = 0.9
)
}
\arguments{
\item{object}{A bexy object.}

\item{scaffoldName}{The scaffold name, must be an autosome.}

\item{threshold_certainty}{The threshold for certainty on the posterior probabilities. All samples that have a posterior probability less than this threshold are classified as 'uncertain'.}
}
\value{
A character vector containing the trisomy classification for each sample for the given scaffold
}
\description{
Getting the posterior mode for each autosomal trisomy
}
\examples{
bex <- bexy()
getPosteriorModeAutosomalTrisomy(bex, "21")
}
\seealso{
\code{\link{bexy}}
}
