% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{plotTernary}
\alias{plotTernary}
\title{Plotting the ternary of a bexy object}
\usage{
plotTernary(
  x,
  colors = c("turquoise3", "darkorange", "royalblue4"),
  sampleNamesToHighlight = c(),
  label = TRUE,
  addSquares = TRUE,
  ...
)
}
\arguments{
\item{x}{A bexy object.}

\item{colors}{A vector of length three with the colors for aneuploid, XX and XY samples, respectively.}

\item{sampleNamesToHighlight}{A vector of sample names that should be highlighted. If empty, samples are automatically highlighted based on the posterior probabilities.}

\item{label}{Boolean indicating whether samples should be labeled.}

\item{addSquares}{Boolean indicating whether 7-cell posterior probability square plots should be drawn.}

\item{...}{Other parameters used for plotting.}
}
\value{
No return value, called for side effects.
}
\description{
Plotting the ternary of a bexy object
}
\examples{
bex <- bexy()
plotTernary(bex)
}
\seealso{
\code{\link{bexy}}
}
