# Read bibtex

    R Development Core Team (2009). _R: A Language and Environment for
    Statistical Computing_. R Foundation for Statistical Computing, Vienna,
    Austria. ISBN 3-900051-07-0, <http://www.R-project.org>.

---

    @Manual{R,
      title = {R: A Language and Environment for Statistical Computing},
      author = {{R Development Core Team}},
      organization = {R Foundation for Statistical Computing},
      address = {Vienna, Austria},
      year = {2009},
      note = {{ISBN} 3-900051-07-0},
      url = {http://www.R-project.org},
    }

# Read base

    Chambers JM (1998). _Programming with Data_. Springer, New York. ISBN
    0-387-98503-4, <http://cm.bell-labs.com/cm/ms/departments/sia/Sbook/>.
    
    Becker RA, Chambers JM, Wilks AR (1988). _The New S Language_. Chapman
    \& Hall, London.
    
    Chambers JM, Hastie TJ (1992). _Statistical Models in S_. Chapman \&
    Hall, London. ISBN 9780412830402.
    
    Dongarra JJ, Bunch JR, Moder CB, Stewart GW (1978). _LINPACK users
    guide_. SIAM, Philadelphia.
    
    Abramowitz M, Stegun IA (1972). _Handbook of Mathematical Functions_.
    Dover Publications, New York.
    
    E. A, ten others (1999). _LAPACK Users Guide_, Third edition.
    <http://www.netlib.org/lapack/lug/lapack_lug.html>.
    
    Smith BT, Boyle JM, Dongarra JJ, Garbow BS, Ikebe Y, Klema V, Moler CB
    (1976). _Matrix Eigensystems Routines - EISPACK Guide_.
    Springer-Verlag.
    
    Lang DT (2001). _An Extensible Conversion Mechanism for .C() calls_.
    <http://developer.R-project.org/CObjectConversion.pdf>.
    
    Wilkinson JH (1965). _The Algebraic Eigenvalue Problem_. Clarendon
    Press, Oxford.
    
    Kernighan BW, Ritchie DM (1988). _The C Programming Language_, Second
    Edition edition. Prentice Hall.
    
    for Standardization IO (2004, 1988, 1997, ...). _ISO 8601. Data
    elements and interchange formats - Information interchange -
    Representation of dates and times_.
    <http://www.qsl.net/g1smd/isopdf.htm>.
    
    R Development Core Team (2009). _Writing R extensions_. R Foundation
    for Statistical Computing, Vienna, Austria.
    <http://cran.r-project.org/doc/manuals/R-exts.html>.
    
    R Development Core Team (2009). _R installation and Administration_. R
    Foundation for Statistical Computing, Vienna, Austria.
    <http://cran.r-project.org/doc/manuals/R-admin.html>.
    
    Lang DT (2001). "In Search of C/C++ & FORTRAN Routines." _R News_,
    *1*(3), 20-23. <http://CRAN.R-project.org/doc/Rnews/>.
    
    Goldberg D (1991). "What Every Computer Scientist Should Know about
    Floating-Point Arithmetic." _ACM Computing Surveys_, *23*(1).
    <http://www.validlab.com/goldberg/>.
    
    Chambers JM, Cleveland WS, Kleiner B, Tukey P (1983). _Graphical
    Methods for Data Analysis_. Wadsworth.
    
    Searle SR (1982). _Matrix Algebra Useful for Statistics_. John Wiley
    and Sons.
    
    Venables WN, Ripley BD (2002). _Modern Applied Statistics with S.
    Fourth Edition_. Springer, New York. ISBN 0-387-95457-0,
    <http://www.stats.ox.ac.uk/pub/MASS4/>.
    
    Jenkins, Traub (1972). "TOMS Algorithm 419." _Comm. ACM_, 97-99.
    
    Ripley BD (1987). _Stochastic Simulation_. Wiley.
    
    Loukides Mea (2002). _Unix Power Tools_. O Reilly.
    
    Sedgewick R (1986). "A new upper bound for Shell sort." _J.
    Algorithms_, 159-173.
    
    Singleton RC (1969). "An efficient algorithm for sorting with minimal
    storage: Algorithm 347." _Communications of the ACM_, 185-187.
    
    Cody WJ (1988). "MACHAR: A subroutine to dynamically determine machine
    parameters." _Transactions on Mathematical Software_, 303-311.
    
    Kuhn M (????). "ASCII and Unicode quotation marks."
    <http://www.cl.cam.ac.uk/~mgk25/ucs/quotes.html>.
    
    Huffman M (2003). "Operating Systems, Unix Shell (bash) / Windows
    Console (CMD.EXE)." <http://www.mhuffman.com/notes/dos/bash_cmd.htm>.
    
    (2009). "Collating Sequence."
    <http://en.wikipedia.org/wiki/Collating_sequence>.
    
    Davis M, Whistler K (2008). "Unicode Collation Algorithm."
    <http://unicode.org/reports/tr10/>.
    
    Ahrens JH, Dieter U (1973). "Extensions of Forsythes method for random
    sampling from the normal distribution." _Mathematics of Computation_,
    927-937.
    
    Box GEP, Muller ME (1958). "A note on the generation of normal random
    deviates." _Annals of Mathematical Statistics_, 610-611.
    
    De Matteis A, Pagnutti S (1993). "Long-range Correlation Analysis of
    the Wichmann-Hill Random Number Generator." _Statist. Comput._, 67-70.
    
    Kinderman AJ, Ramage JG (1976). "Computer generation of normal random
    variables." _Journal of the American Statistical Association_, 893-896.
    
    Knuth DE (1997). _The Art of Computer Programming_, volume 2, Third
    edition edition. Addison-Wesley Professional.
    <http://www-cs-faculty.stanford.edu/~knuth/taocp.html>.
    
    Knuth DE (1997). _The Art of Computer Programming_, volume 2, Third
    edition, ninth printing edition. Addison-Wesley Professional.
    <http://Sunburn.Stanford.EDU/~knuth/news02.html>.
    
    Marsaglia G (1997). "A random number generator for C." Discussion
    paper, posting on sci.stat.math usenet group.
    
    Marsaglia G, Zaman A (1994). "Some portable very-long-period random
    number generators." _Computers in Physics_, 117-121.
    
    Matsumoto M, Nishimura T (1998). "Mersenne Twister: A 623-dimensionally
    equidistributed uniform pseudo-random number generator." _ACM
    Transactions on Modeling and Computer Simulation_, 3-30.
    <http://www.math.keio.ac.jp/~matumoto/emt.html>.
    
    Reeds J, Hubert S, Abrahams M (1982-4). "C implementation of
    SuperDuper, University of California at Berkeley." Personal
    communication from Jim Reeds to Ross Ihaka.
    
    Wichmann BA, Hill ID (1982). "Algorithm AS 183: An Efficient and
    Portable Pseudo-random Number Generator." _Applied Statistics_,
    188-190. Remarks: 34, 198 and 35, 89.
    
    (????). "ANSI/IEEE 754 Floating-Point Standard."
    <http://grouper.ieee.org/groups/754/>.

---

    @Book{R:Chambers:1998,
      author = {John M. Chambers},
      title = {Programming with Data},
      publisher = {Springer},
      year = {1998},
      address = {New York},
      note = {ISBN 0-387-98503-4},
      url = {http://cm.bell-labs.com/cm/ms/departments/sia/Sbook/},
      publisherurl = {http://www.springeronline.com/sgw/cda/frontpage/0,11855,4-40109-22-2008951-0,00.html},
      abstract = {This Green Book describes version 4 of S, a
                      major revision of S designed by John Chambers to
                      improve its usefulness at every stage of the
                      programming process.},
    }
    
    @Book{R:Becker+Chambers+Wilks:1988,
      author = {Richard A. Becker and John M. Chambers and Allan R. Wilks},
      title = {The New {S} Language},
      publisher = {Chapman \& Hall},
      year = {1988},
      address = {London},
      abstract = {This book is often called the {Blue Book},
                      and introduced what is now known as S version 3, or S3.},
    }
    
    @Book{R:Chambers+Hastie:1992,
      author = {John M. Chambers and Trevor J. Hastie},
      title = {Statistical Models in {S}},
      publisher = {Chapman \& Hall},
      year = {1992},
      address = {London},
      note = {ISBN 9780412830402},
      publisherurl = {http://www.crcpress.com/shopping_cart/products/product_detail.asp?sku=C3040&parent_id=&pc=},
      abstract = {This is also called the {White Book}.
                      It described software for statistical modeling in S
                      and introduced the S3 version of classes and methods.},
    }
    
    @Book{linpack,
      author = {J. J. Dongarra and J. R. Bunch and C. B. Moder and G. W. Stewart},
      title = {LINPACK users guide},
      publisher = {SIAM},
      address = {Philadelphia},
      year = {1978},
    }
    
    @Book{handbook+math+functions,
      author = {M. Abramowitz and I. A Stegun},
      year = {1972},
      title = {Handbook of Mathematical Functions},
      address = {New York},
      publisher = {Dover Publications},
    }
    
    @Manual{lapack,
      author = {Anderson. E. and {ten others}},
      year = {1999},
      title = {{LAPACK} Users Guide},
      url = {http://www.netlib.org/lapack/lug/lapack_lug.html},
      publisher = {SIAM},
      edition = {Third},
    }
    
    @Book{eigen,
      author = {B. T Smith and J. M. Boyle and J. J. Dongarra and B. S. Garbow and Y. Ikebe and V. Klema and C. B. Moler},
      year = {1976},
      publisher = {Springer-Verlag},
      title = {Matrix Eigensystems Routines -- {EISPACK} Guide},
    }
    
    @Manual{cobjectconversion,
      author = {Duncan Temple Lang},
      year = {2001},
      url = {http://developer.R-project.org/CObjectConversion.pdf},
      title = {An Extensible Conversion Mechanism for {.C()} calls},
    }
    
    @Book{algebraicEigen,
      author = {J. H. Wilkinson},
      year = {1965},
      publisher = {Clarendon Press},
      address = {Oxford},
      title = {The Algebraic Eigenvalue Problem},
    }
    
    @Book{C,
      author = {B. W. Kernighan and D. M. Ritchie},
      year = {1988},
      title = {The C Programming Language},
      edition = {Second Edition},
      publisher = {Prentice Hall},
    }
    
    @Manual{dateformats,
      author = {International Organization {for Standardization}},
      title = {ISO 8601. Data elements and interchange formats -- Information interchange -- Representation of dates and times},
      year = {2004, 1988, 1997, ...},
      url = {http://www.qsl.net/g1smd/isopdf.htm},
    }
    
    @Manual{R:writingRExtensions,
      author = {{R Development Core Team}},
      organization = {R Foundation for Statistical Computing},
      address = {Vienna, Austria},
      year = {2009},
      title = {Writing R extensions},
      url = {http://cran.r-project.org/doc/manuals/R-exts.html},
    }
    
    @Manual{R:installadmin,
      author = {{R Development Core Team}},
      organization = {R Foundation for Statistical Computing},
      address = {Vienna, Austria},
      year = {2009},
      title = {R installation and Administration},
      url = {http://cran.r-project.org/doc/manuals/R-admin.html},
    }
    
    @Article{Rnews:Lang:2001a,
      author = {Duncan Temple Lang},
      title = {In Search of {C/C++} \& {FORTRAN} Routines},
      journal = {R News},
      year = {2001},
      volume = {1},
      number = {3},
      pages = {20--23},
      month = {September},
      url = {http://CRAN.R-project.org/doc/Rnews/},
      pdf = {http://CRAN.R-project.org/doc/Rnews/Rnews_2001-3.pdf},
    }
    
    @Article{floatingpoint,
      author = {D. Goldberg},
      year = {1991},
      title = {What Every Computer Scientist Should Know about Floating-Point Arithmetic},
      journal = {ACM Computing Surveys},
      volume = {23},
      number = {1},
      url = {http://www.validlab.com/goldberg/},
      pdf = {http://www.validlab.com/goldberg/paper.pdf},
    }
    
    @Book{graphicalmethods,
      author = {J. M. Chambers and W. S. Cleveland and B. Kleiner and P.A. Tukey},
      title = {Graphical Methods for Data Analysis},
      publisher = {Wadsworth},
      year = {1983},
    }
    
    @Book{matrixAlgebra,
      author = {Shayle R. Searle},
      title = {Matrix Algebra Useful for Statistics},
      publisher = {John Wiley and Sons},
      year = {1982},
    }
    
    @Book{MASS,
      author = {William N. Venables and Brian D. Ripley},
      title = {Modern Applied Statistics with {S}. Fourth Edition},
      publisher = {Springer},
      year = {2002},
      address = {New York},
      note = {ISBN 0-387-95457-0},
      url = {http://www.stats.ox.ac.uk/pub/MASS4/},
      publisherurl = {http://www.springeronline.com/sgw/cda/frontpage/0,11855,4-40109-22-1542120-0,00.html},
      abstract = {A highly recommended book on how to do statistical
                      data analysis using R or S-Plus.  In the first
                      chapters it gives an introduction to the S language.
                      Then it covers a wide range of statistical
                      methodology, including linear and generalized linear
                      models, non-linear and smooth regression, tree-based
                      methods, random and mixed effects, exploratory
                      multivariate analysis, classification, survival
                      analysis, time series analysis, spatial statistics,
                      and optimization.  The on-line complements available
                      at the books homepage provide updates of the book, as
                      well as further details of technical material.},
      orderinfo = {http://www.r-project.org/doc/bib/springer.txt},
    }
    
    @Article{toms+algorithm,
      author = {{Jenkins} and {Traub}},
      year = {1972},
      title = {{TOMS} Algorithm 419},
      journal = {Comm. ACM},
      edition = {15},
      pages = {97--99},
    }
    
    @Book{StockasticSimulation,
      author = {B. D. Ripley},
      title = {Stochastic Simulation},
      publisher = {Wiley},
      year = {1987},
    }
    
    @Book{unixpower,
      author = {M. et al Loukides},
      year = {2002},
      title = {Unix Power Tools},
      publisher = {O Reilly},
    }
    
    @Article{shellsort,
      author = {R. Sedgewick},
      title = {A new upper bound for Shell sort},
      journal = {J. Algorithms},
      edition = {7},
      pages = {159--173},
      year = {1986},
    }
    
    @Article{sort+minimal+storage,
      author = {R. C. Singleton},
      title = {An efficient algorithm for sorting with minimal storage: Algorithm 347},
      journal = {Communications of the ACM},
      edition = {12},
      pages = {185--187},
      year = {1969},
    }
    
    @Article{machar,
      author = {W. J. Cody},
      title = {{MACHAR}: A subroutine to dynamically determine machine parameters},
      edition = {14},
      number = {4},
      pages = {303--311},
      year = {1988},
      journal = {Transactions on Mathematical Software},
    }
    
    @Misc{ascii+unicode,
      author = {Markus Kuhn},
      title = {ASCII and Unicode quotation marks},
      url = {http://www.cl.cam.ac.uk/~mgk25/ucs/quotes.html},
    }
    
    @Misc{bash+cmd,
      author = {Mike Huffman},
      title = {Operating Systems, Unix Shell (bash) / Windows Console (CMD.EXE)},
      url = {http://www.mhuffman.com/notes/dos/bash_cmd.htm},
      year = {2003},
    }
    
    @Misc{wikipedia:collating+sequence,
      title = {Collating Sequence},
      year = {2009},
      url = {http://en.wikipedia.org/wiki/Collating_sequence},
    }
    
    @Misc{unicode+collation+algorithm,
      title = {Unicode Collation Algorithm},
      url = {http://unicode.org/reports/tr10/},
      author = {Mark Davis and Ken Whistler},
      year = {2008},
    }
    
    @Article{random:ahrens+dieter,
      title = {Extensions of Forsythes method for random sampling from the normal distribution},
      author = {J. H. Ahrens and U. Dieter},
      year = {1973},
      journal = {Mathematics of Computation},
      edition = {27},
      pages = {927--937},
    }
    
    @Article{random:box+muller,
      title = {A note on the generation of normal random deviates},
      author = {G. E. P. Box and M. E. Muller},
      year = {1958},
      journal = {Annals of Mathematical Statistics},
      edition = {29},
      pages = {610--611},
    }
    
    @Article{random:matteis+pagnutti,
      title = {Long-range Correlation Analysis of the Wichmann-Hill Random Number Generator},
      year = {1993},
      author = {A. {De Matteis} and S. Pagnutti},
      journal = {Statist. Comput.},
      edition = {3},
      pages = {67--70},
    }
    
    @Article{random:kinderman+ramage,
      title = {Computer generation of normal random variables},
      author = {A. J. Kinderman and J. G. Ramage},
      year = {1976},
      journal = {Journal of the American Statistical Association},
      edition = {71},
      pages = {893--896},
    }
    
    @Book{knuth:1997,
      title = {The Art of Computer Programming},
      author = {D. E. Knuth},
      year = {1997},
      volume = {2},
      edition = {Third edition},
      url = {http://www-cs-faculty.stanford.edu/~knuth/taocp.html},
      publisher = {Addison-Wesley Professional},
    }
    
    @Book{knuth:2002,
      title = {The Art of Computer Programming},
      author = {D. E. Knuth},
      year = {1997},
      volume = {2},
      edition = {Third edition, ninth printing},
      url = {http://Sunburn.Stanford.EDU/~knuth/news02.html},
      publisher = {Addison-Wesley Professional},
    }
    
    @Misc{random:marsaglia:1997,
      title = {A random number generator for C},
      author = {G Marsaglia},
      year = {1997},
      note = {Discussion paper, posting on {sci.stat.math} usenet group},
    }
    
    @Article{random:marsaglia+zaman:1998,
      title = {Some portable very-long-period random number generators},
      author = {G. Marsaglia and A. Zaman},
      year = {1994},
      journal = {Computers in Physics},
      edition = {8},
      pages = {117--121},
    }
    
    @Article{random:matsumoto+nishimura:1998,
      author = {M. Matsumoto and T. Nishimura},
      title = {Mersenne Twister: A 623-dimensionally equidistributed uniform pseudo-random number generator},
      journal = {ACM Transactions on Modeling and Computer Simulation},
      edition = {8},
      pages = {3--30},
      url = {http://www.math.keio.ac.jp/~matumoto/emt.html},
      year = {1998},
    }
    
    @Misc{random:superduper,
      author = {J. Reeds and S. Hubert and M. Abrahams},
      title = {C implementation of SuperDuper, University of California at Berkeley},
      year = {1982--4},
      note = {Personal communication from Jim Reeds to Ross Ihaka},
      institution = {University of California at Berkeley},
    }
    
    @Article{random:whichmann+hill:1982,
      title = {Algorithm {AS} 183: An Efficient and Portable Pseudo-random Number Generator},
      journal = {Applied Statistics},
      author = {B. A. Wichmann and I. D. Hill},
      edition = {31},
      pages = {188--190},
      note = {Remarks: 34, 198 and 35, 89},
      year = {1982},
    }
    
    @Misc{ansi754,
      title = {{ANSI/IEEE} 754 Floating-Point Standard},
      url = {http://grouper.ieee.org/groups/754/},
    }

# Read datasets

    Smith GA, G. S (1983). "Clocking g: relating intelligence and measures
    of timed performance." _Intelligence_, 353-368.
    
    Brown RG (1963). _Smoothing, Forecasting and Prediction of Discrete
    Time Series_. Prentice-Hall.
    
    Chambers JM, Cleveland WS, Kleiner B, Tukey PA (1983). _Graphical
    Methods for Data Analysis_. Wadsworth, Belmont, CA.
    
    Anscombe FJ (1973). "Graphs in statistical analysis." _American
    Statistician_, 17-21.
    
    Boore DM, Joyner W (1982). "The empirical prediction of ground motion."
    _Bull. Seism. Soc. Am._, S269-S268.
    
    Bolt BA, Abrahamson NA (1982). "New attenuation relations for peak and
    expected accelerations of strong ground motion." _Bull. Seism. Soc.
    Am._, 2307-2321.
    
    A. BB, Abrahamson NA (1983). "Reply to W. B. Joyner & D. M. Boore's."
    _Bull. Seism. Soc. Am._, 1481-1483. Comments on: New attenuation
    relations for peak and expected accelerations for peak and expected
    accelerations of strong ground motion.
    
    Brillinger DR, Preisler HK (1984). "An exploratory analysis of the
    Joyner-Boore attenuation data." _Bull. Seism. Soc. Am._, 1441-1449.
    
    Brillinger DR, Preisler HK (1984). "Further analysis of the
    Joyner-Boore attenuation data." Manuscript.
    
    Box GEP, Jenkins GM (1976). _Time Series Analysis, Forecasting and
    Control_. Holden-Day, San Francisco.
    
    Brockwell PJ, Davis RA (1991). _Time Series: Theory and Methods_,
    Second edition edition. Springer Verlag, New York.
    
    McNeil DR (1977). _Interactive Data Analysis_. Wiley, New York.
    
    Cleveland WS (1993). _Visualizing Data_. Summit Press, New Jersey.
    
    Garson J (1900). "The metric system of identification of criminals, as
    used in in Great Britain and Ireland." _The Journal of the
    Anthropological Institute of Great Britain and Ireland_, 177-227.
    
    MacDonell W (1902). "On criminal anthropometry and the identification
    of criminals." _Biometrika_, 177-227.
    
    Student (1908). "The probable error of a mean." _Biometrika_, 1-25.
    
    Härdle W (1991). _Smoothing Techniques with Implementation in S_.
    Springer, New York.
    
    Azzalini A, Bowman AW (1990). "A look at some data on the Old Faithful
    geyser." _Applied Statistics_, 357-365.
    
    Snee RD (1974). "Graphical display of two-way contingency tables." _The
    American Statistician_, 9-12.
    
    Friendly M (1992a). "Graphical methods for categorical data." _SAS User
    Group International Conference Proceedings_, 190-200.
    <http://www.math.yorku.ca/SCS/sugi/sugi17-paper.html>.
    
    Friendly M (1992b). "Mosaic displays for loglinear models."
    _Proceedings of the Statistical Graphics Section_, 61-68.
    <http://www.math.yorku.ca/SCS/Papers/asa92.html>.
    
    Friendly M (2000). _Visualizing Categorical Data_. SAS Institute. ISBN
    1-58025-660-0.
    
    Sterling A (1977). Unpublished BS Thesis.
    
    Belsley D. A. KE, Welsch RE (1980). _Regression Diagnostics_. Wiley,
    New York.
    
    Campbell MJ, Walker AM (1977). "A Survey of statistical work on the
    Mackenzie River series of annual Canadian lynx trappings for the years
    1821-1934 and a new analysis." _Journal of the Royal Statistical
    Society_, 411-431.
    
    Balke NS (1993). "Detecting level shifts in time series." _Journal of
    Business and Economic Statistics_, 81-92.
    
    Cobb GW (1978). "The problem of the Nile: conditional solution to a
    change-point problem." _Biometrika_, 243-51.
    
    Scheffé H (1959). _The Analysis of Variance_. Wiley, New York.
    
    Dodge Y (1996). "The guinea pig of multiple regression." _Lecture Notes
    in Statistics_. In: Robust Statistics, Data Analysis, and Computer
    Intensive Methods; In Honor of Peter Huber's 60th Birthday.
    
    Atkinson AC (1985). _Plots, Transformations and Regression_. Oxford
    University Press.
    
    Bickel PJ, Hammel EA, O'Connell JW (1975). "Sex bias in graduate
    admissions: Data from Berkeley." _Science_, 398-403.
    
    Harvey AC, Durbin J (1986). "The effects of seat belt legislation on
    British road casualties: A case study in structural time series
    modelling." _Journal of the Royal Statistical Society_, 187-227.
    
    Tukey JW (1977). _Exploratory Data Analysis_. Addison-Wesley.
    
    McNeil DR (1977). _Interactive Data Analysis_. Wiley.
    
    Makridakis S, Wheelwright SC, Hyndman RJ (1998). _Forecasting: Methods
    and Applications_. Wiley.

---

    @Article{smith+stanley:1983,
      author = {G. A. Smith and Stanley G.},
      year = {1983},
      title = {Clocking g: relating intelligence and measures of timed performance},
      journal = {Intelligence},
      edition = {7},
      pages = {353--368},
    }
    
    @Book{brown:1963,
      author = {R. G. Brown},
      title = {Smoothing, Forecasting and Prediction of Discrete Time Series},
      year = {1963},
      publisher = {Prentice-Hall},
    }
    
    @Book{chambers+cleveland+kleiner+tukey:1983,
      author = {J. M. Chambers and W. S. Cleveland and B. Kleiner and P. A. Tukey},
      year = {1983},
      title = {Graphical Methods for Data Analysis},
      address = {Belmont, CA},
      publisher = {Wadsworth},
    }
    
    @Article{anscombe:1973,
      author = {Francis J. Anscombe},
      year = {1973},
      journal = {American Statistician},
      edition = {27},
      pages = {17--21},
      title = {Graphs in statistical analysis},
    }
    
    @Article{boore+joyner:1982,
      author = {D. M. Boore and W.B. Joyner},
      year = {1982},
      title = {The empirical prediction of ground motion},
      journal = {Bull. Seism. Soc. Am.},
      edition = {72},
      pages = {S269--S268},
    }
    
    @Article{bolt+abrahamson:1982,
      author = {B. A. Bolt and N. A. Abrahamson},
      year = {1982},
      title = {New attenuation relations for peak and expected accelerations of strong ground motion},
      journal = {Bull. Seism. Soc. Am.},
      edition = {72},
      pages = {2307--2321},
    }
    
    @Article{bolt+abrahamson:1983,
      year = {1983},
      title = {Reply to W. B. Joyner & D. M. Boore's},
      note = {Comments on: New attenuation relations for peak and expected accelerations for peak and expected accelerations of strong ground motion},
      journal = {Bull. Seism. Soc. Am.},
      edition = {73},
      pages = {1481--1483},
      author = {Bolt B. A. and N. A. Abrahamson},
    }
    
    @Article{brillinger+preisler:1984,
      author = {D. R. Brillinger and H. K. Preisler},
      year = {1984},
      title = {An exploratory analysis of the Joyner-Boore attenuation data},
      journal = {Bull. Seism. Soc. Am.},
      edition = {74},
      pages = {1441--1449},
    }
    
    @Misc{brillinger+preisler:1984-2,
      author = {D. R. Brillinger and H. K. Preisler},
      year = {1984},
      title = {Further analysis of the Joyner-Boore attenuation data},
      note = {Manuscript},
    }
    
    @Book{box+jenkins:1976,
      author = {G. E. P. Box and G. M. Jenkins},
      year = {1976},
      title = {Time Series Analysis, Forecasting and Control},
      publisher = {Holden-Day},
      address = {San Francisco},
    }
    
    @Book{brockwell+davis:1991,
      author = {P. J. Brockwell and R. A. Davis},
      year = {1991},
      title = {Time Series: Theory and Methods},
      edition = {Second edition},
      publisher = {Springer Verlag},
      address = {New York},
    }
    
    @Book{mcneil:1977,
      author = {D. R. McNeil},
      title = {Interactive Data Analysis},
      year = {1977},
      publisher = {Wiley},
      address = {New York},
    }
    
    @Book{cleveland:1993,
      author = {W. S. Cleveland},
      title = {Visualizing Data},
      year = {1993},
      publisher = {Summit Press},
      address = {New Jersey},
    }
    
    @Article{garson:1900,
      title = {The metric system of identification of criminals, as used in in Great Britain and Ireland},
      author = {J.G. Garson},
      year = {1900},
      journal = {The Journal of the Anthropological Institute of Great Britain and Ireland},
      edition = {30},
      number = {2},
      pages = {177--227},
    }
    
    @Article{macdonell:1902,
      author = {W.R. MacDonell},
      year = {1902},
      title = {On criminal anthropometry and the identification of criminals},
      journal = {Biometrika},
      edition = {1},
      number = {2},
      pages = {177--227},
    }
    
    @Article{student:1908,
      author = {{Student}},
      year = {1908},
      title = {The probable error of a mean},
      journal = {Biometrika},
      edition = {6},
      pages = {1--25},
    }
    
    @Book{haerdle:1991,
      author = {W. Härdle},
      year = {1991},
      title = {Smoothing Techniques with Implementation in S},
      publisher = {Springer},
      address = {New York},
    }
    
    @Article{azzalini+bowman:1990,
      author = {A. Azzalini and A. W. Bowman},
      year = {1990},
      title = {A look at some data on the Old Faithful geyser},
      journal = {Applied Statistics},
      edition = {39},
      pages = {357--365},
    }
    
    @Article{snee:1974,
      author = {R. D. Snee},
      year = {1974},
      title = {Graphical display of two-way contingency tables},
      journal = {The American Statistician},
      edition = {28},
      pages = {9--12},
    }
    
    @Article{friendly:1992a,
      author = {M. Friendly},
      year = {1992a},
      title = {Graphical methods for categorical data},
      journal = {SAS User Group International Conference Proceedings},
      edition = {17},
      pages = {190--200},
      url = {http://www.math.yorku.ca/SCS/sugi/sugi17-paper.html},
    }
    
    @Article{friendly:1992b,
      author = {M. Friendly},
      year = {1992b},
      title = {Mosaic displays for loglinear models},
      journal = {Proceedings of the Statistical Graphics Section},
      institution = {American Statistical Association},
      pages = {61--68},
      url = {http://www.math.yorku.ca/SCS/Papers/asa92.html},
    }
    
    @Book{friendly:2000,
      author = {M. Friendly},
      year = {2000},
      title = {Visualizing Categorical Data},
      publisher = {SAS Institute},
      isbn = {1-58025-660-0},
    }
    
    @Misc{sterling:1977,
      author = {Arnie Sterling},
      year = {1977},
      note = {Unpublished BS Thesis},
      institution = {Massachusetts Institute of Technology},
    }
    
    @Book{belsley+kuh+welsch:1980,
      author = {Kuh. E. {Belsley D. A.} and R. E. Welsch},
      year = {1980},
      title = {Regression Diagnostics},
      address = {New York},
      publisher = {Wiley},
    }
    
    @Article{campbell+Walker:1977,
      author = {M. J. Campbell and A. M. Walker},
      year = {1977},
      title = {A Survey of statistical work on the Mackenzie River series of annual Canadian lynx trappings for the years  1821--1934 and a new analysis},
      journal = {Journal of the Royal Statistical Society},
      series = {A},
      edition = {140},
      pages = {411--431},
    }
    
    @Article{balke:1983,
      author = {N. S. Balke},
      year = {1993},
      title = {Detecting level shifts in time series},
      journal = {Journal of Business and Economic Statistics},
      edition = {11},
      pages = {81--92},
    }
    
    @Article{cobb:1978,
      author = {G. W. Cobb},
      year = {1978},
      title = {The problem of the Nile: conditional solution to a change-point problem},
      journal = {Biometrika},
      edition = {65},
      pages = {243--51},
    }
    
    @Book{scheffe:1959,
      author = {Henry Scheffé},
      year = {1959},
      title = {The Analysis of Variance},
      publisher = {Wiley},
      address = {New York},
    }
    
    @Article{dodge:1996,
      author = {Y. Dodge},
      year = {1996},
      title = {The guinea pig of multiple regression},
      note = {In: Robust Statistics, Data Analysis, and Computer Intensive Methods; In Honor of Peter Huber's 60th Birthday},
      journal = {Lecture Notes in Statistics},
      edition = {109},
      publisher = {Springer-Verlag},
      address = {New York},
    }
    
    @Book{atkinson:1985,
      author = {A. C. Atkinson},
      year = {1985},
      title = {Plots, Transformations and Regression},
      publisher = {Oxford University Press},
    }
    
    @Article{bickel+hammel+oconnell:1975,
      author = {P. J. Bickel and E. A. Hammel and J. W. O'Connell},
      year = {1975},
      title = {Sex bias in graduate admissions: Data from Berkeley},
      journal = {Science},
      edition = {187},
      pages = {398--403},
    }
    
    @Article{harvey+Durbin:1986,
      author = {A. C. Harvey and J. Durbin},
      year = {1986},
      title = {The effects of seat belt legislation on British road casualties: A case study in structural time series modelling},
      journal = {Journal of the Royal Statistical Society},
      series = {B},
      edition = {149},
      pages = {187--227},
    }
    
    @Book{tukey:1977,
      author = {J. W. Tukey},
      year = {1977},
      title = {Exploratory Data Analysis},
      publisher = {Addison-Wesley},
    }
    
    @Book{mcneil:1977,
      author = {D. R. McNeil},
      year = {1977},
      title = {Interactive Data Analysis},
      publisher = {Wiley},
    }
    
    @Book{makridakis+wheelwright+hyndma:1998,
      author = {S. Makridakis and S. C. Wheelwright and R. J. Hyndman},
      year = {1998},
      title = {Forecasting: Methods and Applications},
      publisher = {Wiley},
    }

# Read graphics

    Murrell P (2005). _R Graphics_. Chapman & Hall/CRC Press.
    
    Cohen A (1980). "On the graphical display of the significant components
    in a two-way contingency table." _Communications in Statistics-Theory
    and Methods_, 1025-1041.
    
    Friendly M (1982). "Graphical methods for categorical data." _SAS User
    Group International Conference Proceedings_, 190-200.
    <http://www.math.yorku.ca/SCS/sugi/sugi17-paper.html>.
    
    Meyer D, Zeileis A, Hornik K (2005). "The strucplot framework:
    Visualizing multi-way contingency tables with vcd." Department of
    Statistics and Mathematics, Wirtschaftsuniversität, Wien. Report 22,
    Research Report Series,
    <http://epub.wu-wien.ac.at/dyn/openURL?id=oai:epub.wu-wien.ac.at:epub-wu-01_8a1>.
    
    Chambers JM, Cleveland WS, Kleiner B, Tukey PA (1983). _Graphical
    Methods for Data Analysis_. Wadsworth & Brooks/Cole.
    
    Hofmann H, Theus M (2005). "Interactive graphics for visualizing
    conditional distributions." Unpublished Manuscript.
    
    Cleveland WS (1993). _Visualizing Data_. Summit Press, New Jersey.
    
    Cleveland WS (1985). _The Elements of Graphing Data_. Wadsworth,
    Monterey, CA.
    
    Cleveland WS (1993). _Visualizing Data_. Summit Press, New Jersey:
    Hobart.
    
    Friendly M (1994). "A fourfold display for 2 by 2 by k tables." York
    University, Psychology Department. Technical Report 217,
    <http://www.math.yorku.ca/SCS/Papers/4fold/4fold.ps.gz>.
    
    Murrell PR (1999). "Layouts: A mechanism for arranging plots on a
    page." _Journal of Computational and Graphical Statistics_, 121-134.
    
    Hartigan J, Kleiner B (1984). "A mosaic of television ratings." _The
    American Statistician_, 32-35.
    
    Emerson JW (1998). "Mosaic displays in S-PLUS: A general implementation
    and a case study." _Statistical Computing and Graphics Newsletter
    (ASA)_, 17-23.
    
    Friendly M (1994). "Mosaic displays for multi-way contingency tables."
    _Journal of the American Statistical Association_, 190-200.
    
    Friendly M (????). "The home page of Michael Friendly."
    <http://www.math.yorku.ca/SCS/friendly.html>.
    
    Cleveland WS (1985). _The elements of graphing data_. Wadsworth,
    Monterey, CA, USA.
    
    Freeny AE, Landwehr JM (1990). "Displays for data from large designed
    experiments." _Computer Science and Statistics: Proc. 22nd Symp.
    Interface_, 117-126.
    
    Chambers JM, Hastie TJ (1992). _Statistical Models in S_. Wadsworth &
    Brooks/Cole.
    
    Hummel J (1996). "Linked bar charts: Analysing categorical data
    graphically." _Computational Statistics_, 23-33.
    
    Schilling MF, Watkins AE (1994). "A suggestion for sunflower plots."
    _The American Statistician_, 303-305.
    
    Blanc C, Schlick C (1995). "X-splines : A Spline Model Designed for the
    End User." In _Proceedings of SIGGRAPH 95_, 377-386.
    <http://dept-info.labri.fr/~schlick/DOC/sig1.html>.
    
    Murrell P (1998). _Investigations in Graphical Statistics_. Ph.D.
    thesis, The University of Auckland.

---

    @Book{murrell:2005,
      author = {P. Murrell},
      year = {2005},
      title = {R Graphics},
      publisher = {Chapman & Hall/CRC Press},
    }
    
    @Article{cohen:1980,
      author = {A. Cohen},
      year = {1980},
      title = {On the graphical display of the significant components in a two-way contingency table},
      journal = {Communications in Statistics---Theory and Methods},
      edition = {A9},
      pages = {1025--1041},
    }
    
    @Article{friendly:1992,
      title = {Graphical methods for categorical data},
      journal = {SAS User Group International Conference Proceedings},
      edition = {17},
      pages = {190--200},
      url = {http://www.math.yorku.ca/SCS/sugi/sugi17-paper.html},
      year = {1982},
      author = {M. Friendly},
    }
    
    @TechReport{meyer+zeileis+hornik:2005,
      author = {D. Meyer and A. Zeileis and K. Hornik},
      year = {2005},
      title = {The strucplot framework: Visualizing multi-way contingency tables with vcd},
      note = {Report 22, Research Report Series},
      institution = {Department of Statistics and Mathematics, Wirtschaftsuniversität, Wien},
      url = {http://epub.wu-wien.ac.at/dyn/openURL?id=oai:epub.wu-wien.ac.at:epub-wu-01_8a1},
    }
    
    @Book{chambers+cleveland+kleiner+tukey:1983,
      author = {J. M. Chambers and W. S. Cleveland and B. Kleiner and P. A. Tukey},
      year = {1983},
      title = {Graphical Methods for Data Analysis},
      publisher = {Wadsworth & Brooks/Cole},
    }
    
    @Misc{hofmann+theus:2005,
      author = {H. Hofmann and M. Theus},
      year = {2005},
      title = {Interactive graphics for visualizing conditional distributions},
      note = {Unpublished Manuscript},
    }
    
    @Book{cleveland:1993,
      author = {W. S. Cleveland},
      year = {1993},
      title = {Visualizing Data},
      address = {New Jersey},
      publisher = {Summit Press},
    }
    
    @Book{cleveland:1985,
      author = {W. S. Cleveland},
      year = {1985},
      title = {The Elements of Graphing Data},
      address = {Monterey, CA},
      publisher = {Wadsworth},
    }
    
    @Book{cleveland:1993,
      author = {W. S. Cleveland},
      year = {1993},
      title = {Visualizing Data},
      address = {New Jersey: Hobart},
      publisher = {Summit Press},
    }
    
    @TechReport{friendly:1994,
      author = {M. Friendly},
      year = {1994},
      title = {A fourfold display for 2 by 2 by k tables},
      note = {Technical Report 217},
      institution = {York University, Psychology Department},
      url = {http://www.math.yorku.ca/SCS/Papers/4fold/4fold.ps.gz},
    }
    
    @Article{murrell:1999,
      author = {P. R. Murrell},
      year = {1999},
      title = {Layouts: A mechanism for arranging plots on a page},
      journal = {Journal of Computational and Graphical Statistics},
      edition = {8},
      pages = {121-134},
    }
    
    @Article{hartigan+kleiner:1984,
      author = {J.A. Hartigan and B. Kleiner},
      year = {1984},
      title = {A mosaic of television ratings},
      journal = {The American Statistician},
      edition = {38},
      pages = {32--35},
    }
    
    @Article{emerson:1998,
      author = {J. W. Emerson},
      year = {1998},
      title = {Mosaic displays in S-PLUS: A general implementation and a case study},
      journal = {Statistical Computing and Graphics Newsletter (ASA)},
      edition = {9},
      number = {1},
      pages = {17--23},
    }
    
    @Article{friendly:1994,
      author = {M. Friendly},
      year = {1994},
      title = {Mosaic displays for multi-way contingency tables},
      journal = {Journal of the American Statistical Association},
      edition = {89},
      pages = {190--200},
    }
    
    @Misc{friendly,
      author = {M. Friendly},
      url = {http://www.math.yorku.ca/SCS/friendly.html},
      title = {The home page of Michael Friendly},
    }
    
    @Book{cleveland:1985,
      author = {W. S. Cleveland},
      year = {1985},
      title = {The elements of graphing data},
      address = {Monterey, CA, USA},
      publisher = {Wadsworth},
    }
    
    @Article{freeny+landwehr:1990,
      author = {A. E. Freeny and J. M. Landwehr},
      year = {1990},
      title = {Displays for data from large designed experiments},
      journal = {Computer Science and Statistics: Proc.{ }22nd Symp.{ }Interface},
      pages = {117--126},
      publisher = {Springer Verlag},
    }
    
    @Book{chambers+hastie:1992,
      author = {J. M. Chambers and T. J. Hastie},
      year = {1992},
      title = {Statistical Models in S},
      publisher = {Wadsworth & Brooks/Cole},
    }
    
    @Article{hummel:1996,
      author = {J. Hummel},
      year = {1996},
      title = {Linked bar charts: Analysing categorical data graphically},
      journal = {Computational Statistics},
      edition = {11},
      pages = {23--33},
    }
    
    @Article{schilling+watkins:1994,
      author = {M. F. Schilling and A. E. Watkins},
      year = {1994},
      title = {A suggestion for sunflower plots},
      journal = {The American Statistician},
      edition = {48},
      pages = {303--305},
    }
    
    @InProceedings{blanc+schlick:1995,
      author = {C. Blanc and C. Schlick},
      year = {1995},
      title = {X-splines : A Spline Model Designed for the End User},
      booktitle = {Proceedings of SIGGRAPH 95},
      pages = {377--386},
      url = {http://dept-info.labri.fr/~schlick/DOC/sig1.html},
    }
    
    @PhdThesis{murrell:1988,
      author = {Paul Murrell},
      title = {Investigations in Graphical Statistics},
      school = {The University of Auckland},
      year = {1998},
    }

# Read grDevices

    Tukey JW (1977). _Exploratory Data Analysis_. Addison Wesley.
    
    McGill R, Tukey JW, Larsen WA (1978). "Variations of box plots." _The
    American Statistician_, 12-16.
    
    Velleman PF, Hoaglin DC (1981). _Applications, Basics and Computing of
    Exploratory Data Analysis_. Duxbury Press.
    
    Emerson JD, Strenio J (1983). "Understanding Robust and Exploratory
    Data Analysis." In D. C. Hoaglin FM, Tukey JW (eds.), chapter Boxplots
    and batch comparison. Wiley.
    
    Chambers JM, Cleveland WS, Kleiner B, Tukey PA (1983). _Graphical
    Methods for Data Analysis_. Wadsworth & Brooks/Cole.
    
    Eddy WF (1977). "A new convex hull algorithm for planar sets." _ACM
    Transactions on Mathematical Software_, 398-403.
    
    Eddy WF (1977). "Algorithm 523. CONVEX, A new convex hull algorithm for
    planar sets[Z]." _ACM Transactions on Mathematical Software_, 411-412.
    
    Lindbloom BJ (2001-2009). "Bruce Lindbloom website."
    <http://www.brucelindbloom.com/>.
    
    Ihaka R (2003). "Colour for Presentation Graphics." In _Proceedings of
    the 3rd International Workshop on Distributed Statistical Computing
    (DSC 2003)_. Technische Universität Wien, Vienna, Austria.
    <http://www.ci.tuwien.ac.at/Conferences/DSC-2003>.
    
    The Free Software Foundation (????). "The plotutils package."
    <http://www.gnu.org/software/plotutils/plotutils.html>.
    
    Freedman D, Diaconis P (1981). "On the histogram as a density
    estimator: L_2 theory." _Zeitschrift für Wahrscheinlichkeitstheorie und
    verwandte Gebiete_, 453-476.
    
    Scott DW (1979). "On optimal and data-based histograms." _Biometrika_,
    605-610.
    
    Scott DW (1992). _Multivariate Density Estimation. Theory, Practice,
    and Visualization_. Wiley.
    
    Sturges HA (1926). "The choice of a class interval." _Journal of the
    American Statistical Association_, 65-66.
    
    Knuth DE (1984). _The TeXbook_. Addison-Wesley, Reading, MA.
    
    Lamport L (1994). _LATEX: A Document Preparation System_.
    Addison-Wesley, Reading, MA.
    
    Goossens M, Mittelbach F, Samarin A (1994). _The LATEX Companion._.
    Addison-Wesley, Reading, MA.
    
    Murrell P, Ihaka R (2000). "An approach to providing mathematical
    annotation in plots." _Journal of Computational and Graphical
    Statistics_, 582-599.

---

    @Book{tukey:1977,
      author = {J. W. Tukey},
      year = {1977},
      title = {Exploratory Data Analysis},
      publisher = {Addison Wesley},
    }
    
    @Article{mcgill+tukey+larsen:1978,
      author = {R. McGill and J. W. Tukey and W. A. Larsen},
      year = {1978},
      title = {Variations of box plots},
      journal = {The American Statistician},
      edition = {32},
      pages = {12--16},
    }
    
    @Book{velleman+hoaglin:1981,
      author = {P. F. Velleman and D. C. Hoaglin},
      year = {1981},
      title = {Applications, Basics and Computing of Exploratory Data Analysis},
      publisher = {Duxbury Press},
    }
    
    @InBook{emerson+strenio:1983,
      author = {J. D Emerson and J. Strenio},
      year = {1983},
      chapter = {Boxplots and batch comparison},
      editor = {F. Mosteller {D. C. Hoaglin} and J. W. Tukey},
      publisher = {Wiley},
      title = {Understanding Robust and Exploratory Data Analysis},
    }
    
    @Book{chambers+cleveland+kleiner+tukey:1983,
      author = {J. M. Chambers and W. S. Cleveland and B. Kleiner and P. A. Tukey},
      year = {1983},
      title = {Graphical Methods for Data Analysis},
      publisher = {Wadsworth & Brooks/Cole},
    }
    
    @Article{eddy:1977a,
      author = {W. F. Eddy},
      year = {1977},
      title = {A new convex hull algorithm for planar sets},
      journal = {ACM Transactions on Mathematical Software},
      edition = {3},
      pages = {398--403},
    }
    
    @Article{eddy:1977b,
      author = {W. F. Eddy},
      year = {1977},
      title = {Algorithm 523. CONVEX, A new convex hull algorithm for planar sets[Z]},
      journal = {ACM Transactions on Mathematical Software},
      edition = {3},
      pages = {411--412},
    }
    
    @Misc{conversion,
      url = {http://www.brucelindbloom.com/},
      author = {Bruce Justin Lindbloom},
      year = {2001--2009},
      title = {Bruce Lindbloom website},
    }
    
    @InProceedings{ihaka:2003,
      author = {R. Ihaka},
      year = {2003},
      title = {Colour for Presentation Graphics},
      booktitle = {Proceedings of the 3rd International Workshop on Distributed Statistical Computing (DSC 2003)},
      organization = {Technische Universität Wien, Vienna, Austria},
      url = {http://www.ci.tuwien.ac.at/Conferences/DSC-2003},
    }
    
    @Misc{plotutils,
      author = {{The Free Software Foundation}},
      url = {http://www.gnu.org/software/plotutils/plotutils.html},
      title = {The plotutils package},
    }
    
    @Article{freedman+diaconis:1981,
      author = {D. Freedman and P. Diaconis},
      year = {1981},
      title = {On the histogram as a density estimator: L_2 theory},
      journal = {Zeitschrift für Wahrscheinlichkeitstheorie und verwandte Gebiete},
      edition = {57},
      pages = {453--476},
    }
    
    @Article{scott:1979,
      author = {D. W. Scott},
      year = {1979},
      title = {On optimal and data-based histograms},
      journal = {Biometrika},
      edition = {66},
      pages = {605--610},
    }
    
    @Book{scott:1992,
      author = {D. W. Scott},
      year = {1992},
      title = {Multivariate Density Estimation. Theory, Practice, and Visualization},
      publisher = {Wiley},
    }
    
    @Article{sturges:1926,
      author = {H. A. Sturges},
      year = {1926},
      title = {The choice of a class interval},
      journal = {Journal of the American Statistical Association},
      edition = {21},
      pages = {65--66},
    }
    
    @Book{knuth:1984,
      author = {D. E. Knuth},
      year = {1984},
      title = {The TeXbook},
      address = {Reading, MA},
      publisher = {Addison-Wesley},
    }
    
    @Book{lamport:1994,
      author = {L. Lamport},
      year = {1994},
      title = {{LATEX}: A Document Preparation System},
      address = {Reading, MA},
      publisher = {Addison-Wesley},
    }
    
    @Book{goossens+mittelbach+Samarin:1994,
      author = {M. Goossens and F. Mittelbach and A. Samarin},
      year = {1994},
      title = {The {LATEX} Companion.},
      address = {Reading, MA},
      publisher = {Addison-Wesley},
    }
    
    @Article{murrell+ihaka:2000,
      author = {P. Murrell and R. Ihaka},
      year = {2000},
      title = {An approach to providing mathematical annotation in plots},
      journal = {Journal of Computational and Graphical Statistics},
      edition = {9},
      pages = {582--599},
    }

# Read methods

    Chambers JM (2008). _Software for Data Analysis: Programming with R_.
    Springer.
    
    Chambers JM (1998). _Programming with Data_. Springer.
    
    Chambers JM (2009). "Developments in Class Inheritance and Method
    Selection." <http://stat.stanford.edu/~jmc4/classInheritance.pdf>.

---

    @Book{chambers:2008,
      author = {John M. Chambers},
      year = {2008},
      title = {Software for Data Analysis: Programming with R},
      publisher = {Springer},
    }
    
    @Book{chambers:1998,
      author = {John M. Chambers},
      year = {1998},
      title = {Programming with Data},
      publisher = {Springer},
    }
    
    @Misc{chambers:2009,
      author = {John M. Chambers},
      year = {2009},
      title = {Developments in Class Inheritance and Method Selection},
      url = {http://stat.stanford.edu/~jmc4/classInheritance.pdf},
    }

# Read stats

    Sakamoto Y, Ishiguro M, G. K (1986). _Akaike Information Criterion
    Statistics_. Reidel Publishing Company.
    
    Chambers JM, Freeny A, Heiberger RM (1992). "Statistical Models in S."
    In Chambers JM, Hastie TJ (eds.), chapter Analysis of variance;
    designed experiments. Wadsworth & Brooks/Cole.
    
    Hastie TJ, Pregibon D (1992). "Statistical Models in S." In Chambers
    JM, Hastie TJ (eds.), chapter Generalized linear models. Wadsworth &
    Brooks/Cole.
    
    Chambers JM (1992). "Statistical Models in S." In Chambers JM, Hastie
    TJ (eds.), chapter Linear models. Wadsworth & Brooks/Cole.
    
    Bates DM, Chambers JM (1992). "Statistical Models in S." In Chambers
    JM, Hastie TJ (eds.), chapter Nonlinear models. Wadsworth &
    Brooks/Cole.
    
    Chambers JM, Hastie TJ (1992). "Statistical Models in S." In Chambers
    JM, Hastie TJ (eds.), chapter Statistical models. Wadsworth &
    Brooks/Cole.
    
    Chambers JM (1992). "Statistical Models in S." In Chambers JM, Hastie
    TJ (eds.), chapter Data for models. Wadsworth & Brooks/Cole.
    
    Cleveland WS, Grosse E, Shyu WM (1992). "Statistical Models in S." In
    Chambers JM, Hastie TJ (eds.), chapter Local regression. Wadsworth &
    Brooks/Cole.
    
    Hand DJ, Taylor CC (1987). _Multivariate Analysis of Variance and
    Repeated Measures_. Chapman and Hall.
    
    Bauer DF (1972). "Constructing confidence sets using rank statistics."
    _Journal of the American Statistical Association_, 687-690.
    
    Hajek J, Sidak Z, Sen PK (1999). _Theory of Rank Tests_. Academic
    Press, San Diego, London.
    
    Brockwell PJ, Davis RA (1996). _Introduction to Time Series and
    Forecasting_. Springer, New York.
    
    Gardner G, Harvey AC, Phillips GDA (1980). "Algorithm AS154. An
    algorithm for exact maximum likelihood estimation of
    autoregressive-moving average models by means of Kalman filtering."
    _Applied Statistics_, 311-322.
    
    Harvey AC (1993). _Time Series Models_, 2nd Edition edition. Harvester
    Wheatsheaf.
    
    Harvey AC, McKenzie CR (1982). "Algorithm AS182. An algorithm for
    finite sample prediction from ARIMA processes." _Applied Statistics_,
    180-187.
    
    Jones RH (1980). "Maximum likelihood fitting of ARMA models to time
    series with missing observations." _Technometrics_, 389-395.
    
    Durbin J, Koopman SJ (2001). _Time Series Analysis by State Space
    Methods_. Oxford University Press.
    
    Gardner G, Harvey AC, Phillips GDA (1980). "Algorithm AS154. An
    algorithm for exact maximum likelihood estimation of
    autoregressive-moving average models by means of Kalman filtering."
    _Applied Statistics_, 311-322.
    
    Brockwell PJ, Davis RA (1991). _Time Series: Theory and Methods_,
    Second Edition edition. Springer.
    
    Luetkepohl H (1991). _Introduction to Multiple Time Series Analysis_.
    Springer Verlag, New York.
    
    Percival DP, Walden AT (1998). _Spectral Analysis for Physical
    Applications_. Cambridge University Press.
    
    Whittle P (1963). "On the fitting of multivariate autoregressions and
    the approximate canonical factorization of a spectral density matrix."
    _Biometrika_, 129-134.
    
    Scott DW (1992). _Multivariate Density Estimation. Theory, Practice,
    and Visualization_. Wiley.
    
    Sheather SJ, Jones MC (1991). "A reliable data-based bandwidth
    selection method for kernel density estimation." _Journal of the Royal
    Statistical Society_, 683-690.
    
    Silverman BW (1986). _Density Estimation_. Chapman and Hall, London.
    
    Bartlett MS (1937). "Properties of sufficiency and statistical tests."
    _Proceedings of the Royal Society of London_, 268-282.
    
    Abramowitz M, Stegun IA (1972). _Handbook of Mathematical Functions_.
    Dover, New York.
    
    Johnson NL, Kotz S, Balakrishnan N (1995). _Continuous Univariate
    Distributions_. Wiley, New York.
    
    Clopper CJ, Pearson ES (1934). "The use of confidence or fiducial
    limits illustrated in the case of the binomial." _Biometrika_, 404-413.
    
    Conover WJ (1971). _Practical nonparametric statistics_. John Wiley &
    Sons, New York.
    
    Hollander M, Wolfe DA (1973). _Nonparametric Statistical Methods_. John
    Wiley & Sons, New York.
    
    Gabriel KR (1971). "The biplot graphical display of matrices with
    applications to principal component analysis." _Biometrika_, 453-467.
    
    Gabriel KR, Odoroff CL (1990). "Biplots in biomedical research."
    _Statistics in Medicine_, 469-485.
    
    Gower J, Hand DJ (1996). _Biplots_. Chapman & Hall.
    
    Diaconis P, F. M (1989). "Methods for studying coincidences." _Journal
    of the American Statistical Association_, 853-861.
    
    Box GEP, Pierce DA (1970). "Distribution of residual correlations in
    autoregressive-integrated moving average time series models." _Journal
    of the American Statistical Association_, 1509-1526.
    
    Ljung GM, Box GEP (1978). "On a measure of lack of fit in time series
    models." _Biometrika_, 297-303.
    
    H. H (1936). "Relations between two sets of variables." _Biometrika_,
    321-327.
    
    Seber GAF (1984). _Multivariate Observations_. Wiley, New York.
    
    Hope ACA (1968). "A simplified Monte Carlo significance test
    procedure." _Journal of the Royal Statistical Society_, 582-598.
    
    Patefield WM (1981). "Algorithm AS159.  An efficient method of
    generating r x c tables with given row and column totals." _Applied
    Statistics_, 91-97.
    
    Cailliez F (1983). "The analytical solution of the additive constant
    problem." _Psychometrika_, 343-349.
    
    Cox TF, Cox MAA (1994). _Multidimensional Scaling_. Chapman and Hall.
    
    Gower JC (1966). "Some distance properties of latent root and vector
    methods used in multivariate analysis." _Biometrika_, 325-328.
    
    Mardia KV, Kent JT, Bibby JM (1979). _Multivariate Analysis_. Academic
    Press, London.
    
    Torgerson WS (1958). _Theory and Methods of Scaling_. Wiley, New York.
    
    Lange K (2001). _Numerical Analysis for Statisticians_. Springer.
    
    Brillinger DR (1981). _Time Series: Data Analysis and Theory_, Second
    Edition edition. Holden-Day, San Francisco.
    
    Sneath P, Sokal R (1973). _Numerical Taxonomy: The Principles and
    Practice of Numerical Classification_. Freeman, San Francisco.
    
    Best DJ, Roberts DE (1975). "Algorithm AS 89: The Upper Tail
    Probabilities of Spearman's rho." _Applied Statistics_, 377-379.
    
    Kendall M, Stuart A (1983). _The Advanced Theory of Statistics_, volume
    3. Griffin.
    
    Griewank A, Corliss GF (1991). "Automatic Differentiation of
    Algorithms: Theory, Implementation, and Application." _SIAM
    proceedings_.
    
    Borg I, Groenen P (1997). _Modern Multidimensional Scaling.  Theory and
    Applications_. Springer.
    
    Heiberger RM (1989). _Computation for the Analysis of Designed
    Experiments_. Wiley.
    
    Bartlett MS (1937). "The statistical conception of mental factors."
    _British Journal of Psychology_, 97-104.
    
    Bartlett MS (1938). "Methods of estimating mental factors." _Nature_,
    609-610.
    
    Jöreskog KG (1963). _Statistical Estimation in Factor Analysis_.
    Almqvist and Wicksell.
    
    Lawley DN, Maxwell AE (1971). _Factor Analysis as a Statistical
    Method_, Second edition edition. Butterworths.
    
    Thomson GH (1951). _The Factorial Analysis of Human Ability_. London
    University Press.
    
    P. M, Nelder JA (1989). _Generalized Linear Models_. Chapman and Hall,
    London.
    
    Dobson AJ (1983). _An Introduction to Statistical Modelling_. Chapman
    and Hall, London.
    
    Dobson AJ (1990). _An Introduction to Generalized Linear Models_.
    Chapman and Hall, London.
    
    Cox DR, Snell EJ (1981). _Applied Statistics; Principles and Examples_.
    Chapman and Hall, London.
    
    Singleton RC (1979). "Mixed Radix Fast Fourier Transforms." In eds
    IDSPC (ed.), _Programs for Digital Signal Processing_. IEEE Press.
    
    Agresti A (1990). _Categorical data analysis_. Wiley, New York.
    
    Agresti A (2002). _Categorical data analysis_, Second edition. Wiley,
    New York.
    
    Fisher RA (1935). "The logic of inductive inference." _Journal of the
    Royal Statistical Society_, 39-54.
    
    Fisher RA (1962). "Confidence limits for a cross-product ratio."
    _Australian Journal of Statistics_, 41.
    
    Fisher RA (1970). _Statistical Methods for Research Workers_. Oliver &
    Boyd.
    
    Mehta CR, Patel NR (1986). "Algorithm 643. FEXACT: A Fortran subroutine
    for Fisher's exact test on unordered r*c contingency tables." _ACM
    Transactions on Mathematical Software_, 154-161.
    
    Clarkson DB, Fan Y, Joe H (1993). "A Remark on Algorithm 643: FEXACT:
    An Algorithm for Performing Fisher's Exact Test in r x c Contingency
    Tables." _ACM Transactions on Mathematical Software_, 484-488.
    
    Conover WJ, Johnson ME, Johnson MM (1981). "A comparative study of
    tests for homogeneity of variances, with applications to the outer
    continental shelf bidding data." _Technometrics_, 351-361.
    
    Shea BL (1988). "Algorithm AS 239, Chi-squared and incomplete Gamma
    integral." _Applied Statistics (JRSS C)_, 466-473.
    
    Davison AC, Snell EJ (1991). "Statistical Theory and Modelling. In
    Honour of Sir David Cox, FRS." In Hinkley DV, Reid N, Snell EJ (eds.),
    chapter Residuals and diagnostics. Chapman & Hall.
    
    Everitt B (1974). _Cluster Analysis_. Heinemann Educ. Books., London.
    
    Hartigan JA (1975). _Clustering Algorithms_. Wiley, New York.
    
    Sneath PHA, Sokal RR (1973). _Numerical Taxonomy_. Freeman, San
    Francisco.
    
    Anderberg MR (1973). _Cluster Analysis for Applications_. Academic
    Press, New York.
    
    Gordon AD (1999). _Classification_, Second Edition edition. Chapman and
    Hall / CRC, London.
    
    Murtagh F (1985). "Multidimensional Clustering Algorithms." In
    _COMPSTAT Lectures 4_.
    
    McQuitty L (1966). "Similarity Analysis by Reciprocal Pairs for
    Discrete and Continuous Data." _Educational and Psychological
    Measurement_, 825-831.
    
    Holt CC (1957). "Forecasting seasonals and trends by exponentially
    weighted moving averages." Carnigie Institute. ONR Research Memorandum.
    
    Winters PR (1960). "Forecasting sales by exponentially weighted moving
    averages." _Management Science_, 324-342.
    
    Johnson NL, Kotz S, Kemp AW (1992). _Univariate Discrete
    Distributions_, Second Edition edition. Wiley, New York.
    
    Belsley DA, Kuh E, Welsch RE (1980). _Regression Diagnostics_. Wiley,
    New York.
    
    Cook RD, Weisberg S (1982). _Residuals and Influence in Regression_.
    Chapman and Hall, London.
    
    Williams DA (1987). "Generalized linear model diagnostics using the
    deviance and single case deletions." _Applied Statistics_, 181-191.
    
    Fox J (1997). _Applied Regression, Linear Models, and Related Methods_.
    Sage.
    
    Fox J (2002). _An R and S-Plus Companion to Applied Regression_. Sage
    Publ. <http://www.socsci.mcmaster.ca/jfox/Books/Companion/>.
    
    Piessens R, deDoncker-Kapenga E, Uberhuber C, Kahaner D (1983).
    _Quadpack: a Subroutine Package for Automatic Integration_. Springer
    Verlag.
    
    Tukey JW (1977). _Exploratory Data Analysis_. Addison-Wesley, Reading.
    
    Barlow RE, Bartholomew DJ, Bremner JM, Brunk HD (1972). _Statistical
    inference under order restrictions_. Wiley, London.
    
    Robertson T, Wright FT, Dykstra RL (1988). _Order Restricted
    Statistical Inference_. Wiley, New York.
    
    Bloomfield P (1976). _Fourier Analysis of Time Series: An
    Introduction_. Wiley.
    
    Brockwell P, Davis R (1991). _Time Series: Theory and Methods_, Second
    edition edition. Springer.
    
    Forgy EW (1965). "Cluster analysis of multivariate data: efficiency vs
    interpretability of classifications." _Biometrics_.
    
    Hartigan JA, Wong MA (1979). "A K-means clustering algorithm." _Applied
    Statistics_, 100-108.
    
    Lloyd SP (1957). "Least squares quantization in PCM." Bell
    Laboratories.
    
    Lloyd SP (1982). "Least squares quantization in PCM." _IEEE
    Transactions on Information Theory_, 128-137.
    
    MacQueen J (1967). "Some methods for classification and analysis of
    multivariate observations." In Neyman LMLC&J (ed.), _Proceedings of the
    Fifth Berkeley Symposium on Mathematical Statistics and Probability_, 1
    edition, 281-297. University of California Press, Berkeley, CA.
    
    Birnbaum ZW, Tingey FH (1951). "One-sided confidence contours for
    probability distribution functions." _The Annals of Mathematical
    Statistics_, *4*, 592-596.
    
    Durbin J (1973). _Distribution theory for tests based on the sample
    distribution function_. SIAM.
    
    Marsaglia G, Tsang WW, Wang J (2003). "Evaluating Kolmogorov's
    distribution." _Journal of Statistical Software_.
    <http://www.jstatsoft.org/v08/i18/>.
    
    Wilkinson GN, Rogers CE (1973). "Symbolic descriptions of factorial
    models for analysis of variance." _Applied Statistics_, 392-9.
    
    Harville D (1974). "Bayesian inference for variance components using
    only error contrasts." _Biometrika_, 383-385.
    
    Haberman SJ (1972). "Log-linear fit for contingency tables-Algorithm
    AS51." _Applied Statistics_, 218-225.
    
    Cleveland WS (1979). "Robust locally weighted regression and smoothing
    scatterplots." _Journal of the American Statistical Association_,
    829-836.
    
    Cleveland WS (1981). "LOWESS: A program for smoothing scatterplots by
    robust locally weighted regression." _The American Statistician_, 54.
    
    Krzanowski WJ (1988). _Principles of Multivariate Analysis. A User's
    Perspective._. Oxford University Press.
    
    Krzanowski WJ, Marriott FHC (1994). _Multivariate Analysis. Part I:
    Distributions, Ordination and Inference_. Edward Arnold.
    
    Anderson TW (1958). _An Introduction to Multivariate Statistical
    Analysis_. Wiley.
    
    Anderson TW (1994). _An Introduction to Multivariate Statistical
    Analysis_. Wiley.
    
    Mielke Jr. PW (1967). "Note on some squared rank tests with existing
    ties." _Technometrics_, 312-314.
    
    Dennis JE, Schnabel RB (1983). _Numerical Methods for Unconstrained
    Optimization and Nonlinear Equations_. Prentice-Hall, Englewood Cliffs,
    NJ.
    
    Schnabel RB, Koontz JE, Weiss BE (1985). "A modular system of
    algorithms for unconstrained minimization." _ACM Trans. Math.
    Software_, 419-440.
    
    Bates DM, Watts DG (1988). _Nonlinear Regression Analysis and Its
    Applications_. Wiley.
    
    Welch BL (1951). "On the comparison of several mean values: an
    alternative approach." _Biometrika_, 330-336.
    
    Brent R (1973). _Algorithms for Minimization without Derivatives_.
    Prentice-Hall, Englewood Cliffs N.J.
    
    Belisle CJP (1992). "Convergence theorems for a class of simulated
    annealing algorithms on Rd." _Journal of Applied Probability_, 885-895.
    
    Byrd RH, Lu P, Nocedal J, Zhu C (1995). "A limited memory algorithm for
    bound constrained optimization." _SIAM J. Scientific Computing_,
    1190-1208.
    
    Fletcher R, Reeves CM (1964). "Function minimization by conjugate
    gradients." _Computer Journal_, 148-154.
    
    Nash JC (1990). _Compact Numerical Methods for Computers. Linear
    Algebra and Function Minimisation._. Adam Hilger.
    
    Nelder JA, Mead R (1965). "A simplex algorithm for function
    minimization." _Computer Journal_, 308-313.
    
    Nocedal J, Wright SJ (1999). _Numerical Optimization_. Springer.
    
    Benjamini Y, Hochberg Y (1995). "Controlling the false discovery rate:
    a practical and powerful approach to multiple testing." _Journal of the
    Royal Statistical Society_, 289-300.
    
    Benjamini Y, Yekutieli D (2001). "The control of the false discovery
    rate in multiple testing under dependency." _Annals of Statistics_,
    1165-1188.
    
    Holm S (1979). "A simple sequentially rejective multiple test
    procedure." _Scandinavian Journal of Statistics_, 65-70.
    
    Hommel G (1988). "A stagewise rejective multiple test procedure based
    on a modified Bonferroni test." _Biometrika_, 383-386.
    
    Hochberg Y (1988). "A sharper Bonferroni procedure for multiple tests
    of significance." _Biometrika_, 800-803.
    
    Shaffer JP (1995). "Multiple hypothesis testing." _Annual Review of
    Psychology_, 561-576.
    
    Sarkar S (1998). "Some probability inequalities for ordered MTP2 random
    variables: a proof of Simes conjecture." _Annals of Statistics_,
    494-504.
    
    Sarkar S, Chang CK (1997). "Simes' method for multiple hypothesis
    testing with positively dependent test statistics." _Journal of the
    American Statistical Association_, 1601-1608.
    
    Wright SP (1992). "Adjusted P-values for simultaneous inference."
    _Biometrics_, 1005-1013.
    
    Holt CC (1957). "Forecasting seasonals and trends by exponentially
    weighted moving averages." Carnigie Institute 52. ONR Research
    Memorandum.
    
    Cook RD, Weisberg S (1982). _Residuals and Influence in Regression_.
    Chapman and Hall, London.
    
    Firth D (1991). "Statistical Theory and Modelling. In Honour of Sir
    David Cox, FRS." In Hinkley DV, Reid N, Snell EJ (eds.), chapter
    Generalized Linear Models, 55-82. Chapman and Hall, London.
    
    Hinkley DV (1975). "On power transformations to symmetry."
    _Biometrika_, 101-111.
    
    Kennedy Jr. WJ, Gentle JE (1980). _Statistical Computing_. Marcel
    Dekker.
    
    Blom G (1958). _Statistical Estimates and Transformed Beta Variables_.
    Wiley.
    
    Friedman JH, Stuetzle W (1981). "Projection pursuit regression."
    _Journal of the American Statistical Association_, 817-823.
    
    Friedman JH (1984). "SMART User's Guide." Laboratory for Computational
    Statistics, Stanford University. Technical Report No. 1.
    
    Friedman JH (1984). "A variable span scatterplot smoother." Laboratory
    for Computational Statistics, Stanford University. Technical Report No.
    5.
    
    Banerjee A, Dolado JJ, Galbraith JW, Hendry DF (1993). _Cointegration,
    Error Correction, and the Econometric Analysis of Non-Stationary Data_.
    Oxford University Press, Oxford.
    
    Perron P (1988). "Trends and random walks in macroeconomic time
    series." _Journal of Economic Dynamics and Control_, 297-332.
    
    Wilson EB (1927). "Probable inference, the law of succession, and
    statistical inference." _Journal of the American Statistical
    Association_, 209-212.
    
    Newcombe RG (1998). "Two-Sided Confidence Intervals for the Single
    Proportion: Comparison of Seven Methods." _Statistics in Medicine_,
    857-872.
    
    Newcombe RG (1998). "Interval Estimation for the Difference Between
    Independent Proportions: Comparison of Eleven Methods." _Statistics in
    Medicine_, 873-890.
    
    Quade D (1979). "Using weighted rankings in the analysis of complete
    blocks with additive block effects." _Journal of the American
    Statistical Association_, 680-683.
    
    Hyndman RJ, Fan Y (1996). "Sample quantiles in statistical packages."
    _American Statistician_, 361-365.
    
    Härdle W, Steiger W (1995). "[Algorithm AS 296] Optimal median
    smoothing." _Applied Statistics_, 258-264.
    
    Friedman JH, Stuetzle W (1982). "Smoothing of Scatterplots." Dep.
    Statistics, Stanford U. Report, Project Orion 003.
    
    Maechler M (2003). "Fast Running Medians: Finite Sample and Asymptotic
    Optimality." working paper available from the author.
    
    Royston P (1982). "An extension of Shapiro and Wilk's W test for
    normality to large samples." _Applied Statistics_, 115-124.
    
    Royston P (1982). "Algorithm AS 181: The W test for Normality."
    _Applied Statistics_, 176-180.
    
    Royston P (1995). "Remark AS R94: A remark on Algorithm AS 181: The W
    test for normality." _Applied Statistics_, 547-551.
    
    Velleman PF, Hoaglin DC (1981). _ABC of EDA (Applications, Basics, and
    Computing of Exploratory Data Analysis)_. Duxbury.
    
    Green PJ, Silverman BW (1994). _Nonparametric Regression and
    Generalized Linear Models: A Roughness Penalty Approach_. Chapman and
    Hall.
    
    Hastie TJ, Tibshirani RJ (1990). _Generalized Additive Models_. Chapman
    and Hall.
    
    Thompson D (1990). "Time series analysis of Holocene climate data."
    _Phil. Trans. Roy. Soc. A_, 601-616.
    
    Bloomfield P (1976). _Fourier Analysis of Time Series: An
    Introduction_. Wiley.
    
    Forsythe GE, Malcolm MA, Moler CB (1977). _Computer Methods for
    Mathematical Computations_. Prentice Hall.
    
    Fritsch FN, Carlson RE (1980). "Monotone piecewise cubic
    interpolation." _SIAM Journal on Numerical Analysis_, 238-246.
    
    Ratkowsky DA (1983). _Nonlinear Regression Modeling_. Dekker.
    
    Cleveland RB, Cleveland WS, McRae J, Terpenning I (1990). "STL: A
    Seasonal-Trend Decomposition Procedure Based on Loess." _Journal of
    Official Statistics_, 3-73.
    
    Harvey AC (1989). _Forecasting, Structural Time Series Models and the
    Kalman Filter_. Cambridge University Press.
    
    Miller RG (1981). _Simultaneous Statistical Inference_. Springer.
    
    Yandell BS (1997). _Practical Data Analysis for Designed Experiments_.
    Chapman & Hall.
    
    Copenhaver MD, Holland BS (1988). "Multiple comparisons of simple
    effects in the two-way analysis of variance with fixed effects."
    _Journal of Statistical Computation and Simulation_, 1-15.
    
    Hendrickson AE, White PO (1964). "Promax: a quick method for rotation
    to orthogonal oblique structure." _British Journal of Statistical
    Psychology_, 65-70.
    
    Horst P (1965). _Factor Analysis of Data Matrices_. Holt, Rinehart and
    Winston.
    
    Kaiser HF (1958). "The varimax criterion for analytic rotation in
    factor analysis." _Psychometrika_, 187-200.

---

    @Book{sakamoto+ishiguro+kitagawa:1986,
      author = {Y. Sakamoto and M. Ishiguro and Kitagawa G.},
      year = {1986},
      title = {Akaike Information Criterion Statistics},
      publisher = {Reidel Publishing Company},
    }
    
    @InBook{chambers+freeny+heiberger:1992,
      author = {J. M. Chambers and A. Freeny and R. M. Heiberger},
      title = {Statistical Models in S},
      chapter = {Analysis of variance; designed experiments},
      editor = {J. M. Chambers and T. J. Hastie},
      year = {1992},
      publisher = {Wadsworth & Brooks/Cole},
    }
    
    @InBook{hastie+pregibon:1992,
      author = {T. J. Hastie and D. Pregibon},
      title = {Statistical Models in S},
      editor = {J. M. Chambers and T. J. Hastie},
      year = {1992},
      publisher = {Wadsworth & Brooks/Cole},
      chapter = {Generalized linear models},
    }
    
    @InBook{chambers:1992:chap4,
      author = {J. M. Chambers},
      chapter = {Linear models},
      editor = {J. M. Chambers and T. J. Hastie},
      year = {1992},
      publisher = {Wadsworth & Brooks/Cole},
      title = {Statistical Models in S},
    }
    
    @InBook{bates+chambers:1992,
      author = {D. M. Bates and J. M. Chambers},
      year = {1992},
      title = {Statistical Models in S},
      chapter = {Nonlinear models},
      editor = {J. M. Chambers and T. J. Hastie},
      publisher = {Wadsworth & Brooks/Cole},
    }
    
    @InBook{chambers+hastie:1992,
      author = {J. M. Chambers and T. J. Hastie},
      year = {1992},
      title = {Statistical Models in S},
      chapter = {Statistical models},
      editor = {J. M. Chambers and T. J. Hastie},
      publisher = {Wadsworth & Brooks/Cole},
    }
    
    @InBook{chambers:1992,
      author = {J. M. Chambers},
      year = {1992},
      title = {Statistical Models in S},
      chapter = {Data for models},
      editor = {J. M. Chambers and T. J. Hastie},
      publisher = {Wadsworth & Brooks/Cole},
    }
    
    @InBook{chambers:1992,
      author = {W. S. Cleveland and E. Grosse and W. M. Shyu},
      year = {1992},
      title = {Statistical Models in S},
      chapter = {Local regression},
      editor = {J. M. Chambers and T. J. Hastie},
      publisher = {Wadsworth & Brooks/Cole},
    }
    
    @Book{hand+taylor:1987,
      author = {D. J. Hand and C. C. Taylor},
      title = {Multivariate Analysis of Variance and Repeated Measures},
      year = {1987},
      publisher = {Chapman and Hall},
    }
    
    @Article{bauer:1972,
      author = {David F. Bauer},
      year = {1972},
      title = {Constructing confidence sets using rank statistics},
      journal = {Journal of the American Statistical Association},
      edition = {67},
      pages = {687--690},
    }
    
    @Book{hajek+sidak+sen:1999,
      author = {Jaroslav Hajek and Zbynek Sidak and Pranab K. Sen},
      year = {1999},
      title = {Theory of Rank Tests},
      address = {San Diego, London},
      publisher = {Academic Press},
    }
    
    @Book{brockwell+davis:1996,
      author = {P. J. Brockwell and R. A. Davis},
      year = {1996},
      title = {Introduction to Time Series and Forecasting},
      publisher = {Springer},
      address = {New York},
    }
    
    @Article{gardner+harvey+phillips:1980,
      author = {G. Gardner and A. C. Harvey and G. D. A. Phillips},
      year = {1980},
      title = {Algorithm AS154. An algorithm for exact maximum likelihood estimation of autoregressive-moving average models by means of Kalman filtering},
      journal = {Applied Statistics},
      edition = {29},
      pages = {311--322},
    }
    
    @Book{harvey:1993,
      author = {A. C. Harvey},
      year = {1993},
      title = {Time Series Models},
      edition = {2nd Edition},
      publisher = {Harvester Wheatsheaf},
    }
    
    @Article{harvey+mckenzie:1982,
      author = {A. C. Harvey and C. R. McKenzie},
      year = {1982},
      title = {Algorithm AS182. An algorithm for finite sample prediction from ARIMA processes},
      journal = {Applied Statistics},
      edition = {31},
      pages = {180--187},
    }
    
    @Article{jones:1980,
      author = {R. H. Jones},
      year = {1980},
      title = {Maximum likelihood fitting of ARMA models to time series with missing observations},
      journal = {Technometrics},
      edition = {20},
      pages = {389--395},
    }
    
    @Book{durbin+koopman:2001,
      author = {J. Durbin and S. J. Koopman},
      year = {2001},
      title = {Time Series Analysis by State Space Methods},
      publisher = {Oxford University Press},
    }
    
    @Article{gardener+harvey+phillips:1980,
      author = {G Gardner and A. C. Harvey and G. D. A. Phillips},
      year = {1980},
      title = {Algorithm AS154. An algorithm for exact maximum likelihood estimation of autoregressive-moving average models by means of Kalman filtering.},
      journal = {Applied Statistics},
      edition = {29},
      pages = {311--322},
    }
    
    @Book{brockwell+davis:1991,
      author = {P. J. Brockwell and R. A. Davis},
      year = {1991},
      title = {Time Series: Theory and Methods},
      edition = {Second Edition},
      publisher = {Springer},
    }
    
    @Book{Luetkepohl:1991,
      author = {H. Luetkepohl},
      year = {1991},
      title = {Introduction to Multiple Time Series Analysis},
      publisher = {Springer Verlag},
      address = {New York},
    }
    
    @Book{percival+walden:1998,
      author = {D. P. Percival and A. T. Walden},
      year = {1998},
      title = {Spectral Analysis for Physical Applications},
      publisher = {Cambridge University Press},
    }
    
    @Article{whittle:1963,
      author = {P. Whittle},
      year = {1963},
      title = {On the fitting of multivariate autoregressions and the approximate canonical factorization of a spectral density matrix},
      journal = {Biometrika},
      edition = {40},
      pages = {129--134},
    }
    
    @Book{scott:1992,
      author = {D. W. Scott},
      year = {1992},
      title = {Multivariate Density Estimation. Theory, Practice, and Visualization},
      publisher = {Wiley},
    }
    
    @Article{sheather+jones:1991,
      author = {S. J. Sheather and M. C. Jones},
      year = {1991},
      title = {A reliable data-based bandwidth selection method for kernel density estimation},
      journal = {Journal of the Royal Statistical Society},
      series = {B},
      edition = {53},
      pages = {683--690},
    }
    
    @Book{silverman:1986,
      author = {B. W. Silverman},
      year = {1986},
      title = {Density Estimation},
      address = {London},
      publisher = {Chapman and Hall},
    }
    
    @Article{bartlett:1937,
      author = {M. S. Bartlett},
      year = {1937},
      title = {Properties of sufficiency and statistical tests},
      journal = {Proceedings of the Royal Society of London},
      series = {A},
      edition = {160},
      pages = {268--282},
    }
    
    @Book{abramowitz+stegun:1972,
      author = {M. Abramowitz and I. A. Stegun},
      year = {1972},
      title = {Handbook of Mathematical Functions},
      address = {New York},
      publisher = {Dover},
    }
    
    @Book{johnson+balakrishnan:1995,
      author = {N. L. Johnson and S. Kotz and N. Balakrishnan},
      year = {1995},
      title = {Continuous Univariate Distributions},
      publisher = {Wiley},
      address = {New York},
    }
    
    @Article{clopper+pearson:1934,
      author = {C. J. Clopper and E. S. Pearson},
      year = {1934},
      title = {The use of confidence or fiducial limits illustrated in the case of the binomial},
      journal = {Biometrika},
      edition = {26},
      pages = {404--413},
    }
    
    @Book{conover:1971,
      author = {William J. Conover},
      year = {1971},
      title = {Practical nonparametric statistics},
      address = {New York},
      publisher = {John Wiley & Sons},
    }
    
    @Book{hollander+wolfe:1973,
      author = {Myles Hollander and Douglas A. Wolfe},
      year = {1973},
      title = {Nonparametric Statistical Methods},
      address = {New York},
      publisher = {John Wiley & Sons},
    }
    
    @Article{gabriel:1971,
      author = {K. R. Gabriel},
      year = {1971},
      title = {The biplot graphical display of matrices with applications to principal component analysis},
      journal = {Biometrika},
      edition = {58},
      pages = {453--467},
    }
    
    @Article{gabriel+odoroff:1990,
      author = {K. R. Gabriel and C. L. Odoroff},
      year = {1990},
      title = {Biplots in biomedical research},
      journal = {Statistics in Medicine},
      edition = {9},
      pages = {469--485},
    }
    
    @Book{gower+hand:1996,
      author = {J.C. Gower and D. J. Hand},
      year = {1996},
      title = {Biplots},
      publisher = {Chapman & Hall},
    }
    
    @Article{diaconis+mosteller:1989,
      author = {P. Diaconis and Mosteller F.},
      year = {1989},
      title = {Methods for studying coincidences},
      journal = {Journal of the American Statistical Association},
      edition = {84},
      pages = {853-861},
    }
    
    @Article{box+pierce:1970,
      author = {G. E. P. Box and D. A. Pierce},
      year = {1970},
      title = {Distribution of residual correlations in autoregressive-integrated moving average time series models},
      journal = {Journal of the American Statistical Association},
      edition = {65},
      pages = {1509--1526},
    }
    
    @Article{ljung+boc:1978,
      author = {G. M. Ljung and G. E. P. Box},
      year = {1978},
      title = {On a measure of lack of fit in time series models},
      journal = {Biometrika},
      edition = {65},
      pages = {297--303},
    }
    
    @Article{hotelling:1936,
      author = {Hotelling H.},
      year = {1936},
      title = {Relations between two sets of variables},
      journal = {Biometrika},
      edition = {28},
      pages = {321--327},
    }
    
    @Book{seber:1984,
      author = {G. A. F. Seber},
      year = {1984},
      title = {Multivariate Observations},
      address = {New York},
      publisher = {Wiley},
    }
    
    @Article{hope:1968,
      author = {A. C. A. Hope},
      year = {1968},
      title = {A simplified Monte Carlo significance test procedure},
      journal = {Journal of the Royal Statistical Society},
      series = {B},
      edition = {30},
      pages = {582--598},
    }
    
    @Article{patefield:1981,
      author = {W. M. Patefield},
      year = {1981},
      title = {Algorithm AS159.  An efficient method of generating r x c tables with given row and column totals},
      journal = {Applied Statistics},
      edition = {30},
      pages = {91--97},
    }
    
    @Article{cailliez:1983,
      author = {F. Cailliez},
      year = {1983},
      title = {The analytical solution of the additive constant problem},
      journal = {Psychometrika},
      edition = {48},
      pages = {343--349},
    }
    
    @Book{cox+cox:1994,
      author = {T. F. Cox and M. A. A. Cox},
      year = {1994},
      title = {Multidimensional Scaling},
      publisher = {Chapman and Hall},
    }
    
    @Article{gower:1966,
      author = {J. C. Gower},
      year = {1966},
      title = {Some distance properties of latent root and vector methods used in multivariate analysis},
      journal = {Biometrika},
      edition = {53},
      pages = {325--328},
    }
    
    @Book{mardia+kent+bibby:1979,
      author = {K. V. Mardia and J. T. Kent and J. M. Bibby},
      year = {1979},
      address = {London},
      publisher = {Academic Press},
      title = {Multivariate Analysis},
    }
    
    @Book{torgerson:1958,
      author = {W. S. Torgerson},
      year = {1958},
      title = {Theory and Methods of Scaling},
      address = {New York},
      publisher = {Wiley},
    }
    
    @Book{lange:2001,
      author = {K. Lange},
      title = {Numerical Analysis for Statisticians},
      publisher = {Springer},
      year = {2001},
    }
    
    @Book{brillinger:1981,
      author = {D. R. Brillinger},
      year = {1981},
      title = {Time Series: Data Analysis and Theory},
      edition = {Second Edition},
      address = {San Francisco},
      publisher = {Holden-Day},
    }
    
    @Book{sneath+sokal:1973,
      author = {P.H.A. Sneath and R.R. Sokal},
      year = {1973},
      title = {Numerical Taxonomy: The Principles and Practice of Numerical Classification},
      publisher = {Freeman},
      address = {San Francisco},
    }
    
    @Article{best+roberts:1975,
      author = {D. J. Best and D. E. Roberts},
      year = {1975},
      title = {Algorithm AS 89: The Upper Tail Probabilities of Spearman's \eqn{\rho}{rho}},
      journal = {Applied Statistics},
      edition = {24},
      pages = {377--379},
    }
    
    @Book{kendall+stuart:1983,
      author = {M. Kendall and A. Stuart},
      year = {1983},
      title = {The Advanced Theory of Statistics},
      volume = {3},
      publisher = {Griffin},
      pages = {410--414},
    }
    
    @Article{griewank+corliss:1991,
      author = {A. Griewank and G. F. Corliss},
      year = {1991},
      title = {Automatic Differentiation of Algorithms: Theory, Implementation, and Application},
      journal = {SIAM proceedings},
      address = {Philadelphia},
    }
    
    @Book{borg+groenen:1997,
      author = {I. Borg and P. Groenen},
      year = {1997},
      title = {Modern Multidimensional Scaling.  Theory and Applications},
      publisher = {Springer},
    }
    
    @Book{heiberger:1989,
      author = {R. M. Heiberger},
      year = {1989},
      title = {Computation for the Analysis of Designed Experiments},
      publisher = {Wiley},
    }
    
    @Article{bartlett:1937,
      author = {M. S. Bartlett},
      year = {1937},
      title = {The statistical conception of mental factors},
      journal = {British Journal of Psychology},
      edition = {28},
      pages = {97--104},
    }
    
    @Article{bartlett:1938,
      author = {M. S. Bartlett},
      year = {1938},
      title = {Methods of estimating mental factors.},
      journal = {Nature},
      edition = {141},
      pages = {609--610},
    }
    
    @Book{joreskog:1963,
      author = {K. G. Jöreskog},
      year = {1963},
      title = {Statistical Estimation in Factor Analysis},
      publisher = {Almqvist and Wicksell},
    }
    
    @Book{lawley+maxwell:1971,
      author = {D. N. Lawley and A. E. Maxwell},
      year = {1971},
      title = {Factor Analysis as a Statistical Method},
      edition = {Second edition},
      publisher = {Butterworths},
    }
    
    @Book{thomson:1951,
      author = {G. H. Thomson},
      year = {1951},
      title = {The Factorial Analysis of Human Ability},
      publisher = {London University Press},
    }
    
    @Book{mccullagh+nelder:1989,
      author = {McCullagh P. and J. A. Nelder},
      year = {1989},
      title = {Generalized Linear Models},
      address = {London},
      publisher = {Chapman and Hall},
    }
    
    @Book{dobson:1983,
      author = {A. J. Dobson},
      year = {1983},
      title = {An Introduction to Statistical Modelling},
      address = {London},
      publisher = {Chapman and Hall},
    }
    
    @Book{dobson:1990,
      author = {A. J. Dobson},
      year = {1990},
      title = {An Introduction to Generalized Linear Models},
      address = {London},
      publisher = {Chapman and Hall},
    }
    
    @Book{cox+snell:1981,
      author = {D. R. Cox and E. J. Snell},
      year = {1981},
      title = {Applied Statistics; Principles and Examples},
      address = {London},
      publisher = {Chapman and Hall},
    }
    
    @InProceedings{singleton:1979,
      author = {R. C. Singleton},
      year = {1979},
      title = {Mixed Radix Fast Fourier Transforms},
      booktitle = {Programs for Digital Signal Processing},
      editor = {IEEE Digital Signal Processing Committee eds},
      organization = {IEEE Press},
    }
    
    @Book{agresti:1990,
      author = {A. Agresti},
      year = {1990},
      title = {Categorical data analysis},
      address = {New York},
      publisher = {Wiley},
    }
    
    @Book{agresti:2002,
      author = {A. Agresti},
      year = {2002},
      title = {Categorical data analysis},
      address = {New York},
      edition = {Second},
      publisher = {Wiley},
    }
    
    @Article{fisher:1935,
      author = {R. A. Fisher},
      year = {1935},
      title = {The logic of inductive inference},
      journal = {Journal of the Royal Statistical Society},
      series = {A},
      edition = {98},
      pages = {39--54},
    }
    
    @Article{fisher:1962,
      author = {R. A. Fisher},
      year = {1962},
      title = {Confidence limits for a cross-product ratio},
      journal = {Australian Journal of Statistics},
      edition = {4},
      pages = {41},
    }
    
    @Book{fisher:1970,
      author = {R. A. Fisher},
      year = {1970},
      title = {Statistical Methods for Research Workers},
      publisher = {Oliver & Boyd},
    }
    
    @Article{mehta+patel:1986,
      author = {C. R. Mehta and N. R. Patel},
      year = {1986},
      title = {Algorithm 643. FEXACT: A Fortran subroutine for Fisher's exact test on unordered {r*c} contingency tables},
      journal = {ACM Transactions on Mathematical Software},
      edition = {12},
      pages = {154--161},
    }
    
    @Article{clarckson+fan+joe:1993,
      author = {D. B Clarkson and Y. Fan and H. Joe},
      year = {1993},
      title = {A Remark on Algorithm 643: FEXACT: An Algorithm for Performing Fisher's Exact Test in {r x c} Contingency Tables},
      journal = {ACM Transactions on Mathematical Software},
      edition = {19},
      pages = {484--488},
    }
    
    @Article{conover+johnson+johnson:1981,
      author = {William J. Conover and Mark E. Johnson and Myrle M. Johnson},
      year = {1981},
      title = {A comparative study of tests for homogeneity of variances, with applications to the outer continental shelf bidding data},
      journal = {Technometrics},
      edition = {23},
      pages = {351--361},
    }
    
    @Article{shea:1988,
      author = {B. L. Shea},
      year = {1988},
      title = {Algorithm AS 239,  Chi-squared and incomplete Gamma integral},
      journal = {Applied Statistics (JRSS C)},
      edition = {37},
      pages = {466--473},
    }
    
    @InBook{davison+snell:1991,
      author = {A. C. Davison and E. J. Snell},
      year = {1991},
      chapter = {Residuals and diagnostics.},
      title = {Statistical Theory and Modelling. In Honour of Sir David Cox, FRS},
      editor = {D. V. Hinkley and N. Reid and E. J. Snell},
      publisher = {Chapman & Hall},
    }
    
    @Book{everitt:1974,
      author = {B. Everitt},
      year = {1974},
      title = {Cluster Analysis},
      address = {London},
      publisher = {Heinemann Educ. Books.},
    }
    
    @Book{hartigan:1975,
      author = {J. A. Hartigan},
      year = {1975},
      title = {Clustering  Algorithms},
      address = {New York},
      publisher = {Wiley},
    }
    
    @Book{sneath+sokal:1973,
      author = {P. H. A. Sneath and R. R. Sokal},
      year = {1973},
      title = {Numerical Taxonomy},
      address = {San Francisco},
      publisher = {Freeman},
    }
    
    @Book{anderberg:1973,
      author = {M. R. Anderberg},
      year = {1973},
      title = {Cluster Analysis for Applications},
      publisher = {Academic Press},
      address = {New York},
    }
    
    @Book{gordon:1999,
      author = {A. D. Gordon},
      year = {1999},
      title = {Classification},
      edition = {Second Edition},
      address = {London},
      publisher = {Chapman and Hall / CRC},
    }
    
    @InProceedings{murtagh:1985,
      author = {F. Murtagh},
      year = {1985},
      title = {Multidimensional Clustering Algorithms},
      booktitle = {COMPSTAT Lectures 4},
      address = {Wuerzburg},
      publisher = {Physica-Verlag},
    }
    
    @Article{mcquitty:1966,
      author = {L.L. McQuitty},
      year = {1966},
      title = {Similarity Analysis by Reciprocal Pairs for Discrete and Continuous Data},
      journal = {Educational and Psychological Measurement},
      edition = {26},
      pages = {825--831},
    }
    
    @TechReport{holt:1957,
      author = {C. C. Holt},
      year = {1957},
      title = {Forecasting seasonals and trends by exponentially weighted moving averages},
      note = {ONR Research Memorandum},
      institution = {Carnigie Institute},
      edition = {52},
    }
    
    @Article{winters:1960,
      author = {P. R. Winters},
      year = {1960},
      title = {Forecasting sales by exponentially weighted moving averages},
      journal = {Management Science},
      edition = {6},
      pages = {324--342},
    }
    
    @Book{johnson+kotz+kemp:1992,
      author = {N. L. Johnson and S. Kotz and A. W. Kemp},
      year = {1992},
      title = {Univariate Discrete Distributions},
      edition = {Second Edition},
      address = {New York},
      publisher = {Wiley},
    }
    
    @Book{belsley+kuh+welsch:1980,
      author = {D. A. Belsley and E. Kuh and R. E. Welsch},
      year = {1980},
      title = {Regression Diagnostics},
      address = {New York},
      publisher = {Wiley},
    }
    
    @Book{cook+weisberg:1982,
      author = {R. D. Cook and S. Weisberg},
      year = {1982},
      title = {Residuals and Influence in Regression},
      address = {London},
      publisher = {Chapman and Hall},
    }
    
    @Article{williams:1987,
      author = {D. A. Williams},
      year = {1987},
      title = {Generalized linear model diagnostics using the deviance and single case deletions},
      journal = {Applied Statistics},
      edition = {36},
      pages = {181--191},
    }
    
    @Book{fox:1997,
      author = {J. Fox},
      year = {1997},
      title = {Applied Regression, Linear Models, and Related Methods},
      publisher = {Sage},
    }
    
    @Book{fox:2002,
      author = {J. Fox},
      year = {2002},
      title = {An R and S-Plus Companion to Applied Regression},
      publisher = {Sage Publ.},
      url = {http://www.socsci.mcmaster.ca/jfox/Books/Companion/},
    }
    
    @Book{piessens+dedoncker-kapenga+uberhuber+kahaner:1983,
      author = {R. Piessens and E. deDoncker-Kapenga and C. Uberhuber and D. Kahaner},
      year = {1983},
      title = {Quadpack: a Subroutine Package for Automatic Integration},
      publisher = {Springer Verlag},
    }
    
    @Book{tukey:1977,
      author = {J. W. Tukey},
      year = {1977},
      title = {Exploratory Data Analysis},
      address = {Reading},
      publisher = {Addison-Wesley},
    }
    
    @Book{barlow+bartholomew+bremner+brunk:1972,
      author = {R. E. Barlow and D. J. Bartholomew and J. M. Bremner and H. D. Brunk},
      year = {1972},
      title = {Statistical inference under order restrictions},
      publisher = {Wiley},
      address = {London},
    }
    
    @Book{robertson+wright+dykstra:1988,
      author = {T. Robertson and F. T. Wright and R. L. Dykstra},
      year = {1988},
      title = {Order Restricted Statistical Inference},
      publisher = {Wiley},
      address = {New York},
    }
    
    @Book{bloomfield:1976,
      author = {P. Bloomfield},
      year = {1976},
      title = {Fourier Analysis of Time Series: An Introduction},
      publisher = {Wiley},
    }
    
    @Book{brockwell+davis:1991,
      author = {P.J. Brockwell and R.A. Davis},
      year = {1991},
      title = {Time Series: Theory and Methods},
      edition = {Second edition},
      publisher = {Springer},
    }
    
    @Article{forgy:1965,
      author = {E. W. Forgy},
      year = {1965},
      title = {Cluster analysis of multivariate data: efficiency vs interpretability of classifications},
      journal = {Biometrics},
      edition = {21},
      publisher = {768--769},
    }
    
    @Article{hartigan+wong:1979,
      author = {J. A. Hartigan and M. A. Wong},
      year = {1979},
      title = {A K-means clustering algorithm},
      journal = {Applied Statistics},
      edition = {28},
      pages = {100--108},
    }
    
    @TechReport{lloyd:1957,
      author = {S. P. Lloyd},
      title = {Least squares quantization in PCM},
      year = {1957},
      institution = {Bell Laboratories},
    }
    
    @Article{lloyd:1982,
      author = {S. P. Lloyd},
      title = {Least squares quantization in PCM},
      year = {1982},
      journal = {IEEE Transactions on Information Theory},
      edition = {28},
      pages = {128--137},
    }
    
    @InProceedings{macqueen:1967,
      author = {J. MacQueen},
      year = {1967},
      title = {Some methods for classification and analysis of multivariate observations},
      booktitle = {Proceedings of the Fifth Berkeley Symposium on  Mathematical Statistics and  Probability},
      editor = {L. M. Le Cam & J. Neyman},
      edition = {1},
      pages = {281--297},
      address = {Berkeley, CA},
      organization = {University of California Press},
    }
    
    @Article{birnbaum+tingey:1951,
      author = {Z. W. Birnbaum and Fred H. Tingey},
      year = {1951},
      title = {One-sided confidence contours for probability distribution functions},
      journal = {The Annals of Mathematical Statistics},
      edition = {22},
      volume = {4},
      pages = {592--596},
    }
    
    @Book{durbin:1973,
      author = {J. Durbin},
      year = {1973},
      title = {Distribution theory for tests based on the sample distribution function},
      publisher = {SIAM},
    }
    
    @Article{marsaglia+tsang+wang:2003,
      author = {George Marsaglia and Wai Wan Tsang and Jingbo Wang},
      year = {2003},
      title = {Evaluating Kolmogorov's distribution},
      journal = {Journal of Statistical Software},
      edition = {8},
      number = {18},
      url = {http://www.jstatsoft.org/v08/i18/},
    }
    
    @Article{wilkinson+rogers:1973,
      author = {G. N. Wilkinson and C. E. Rogers},
      year = {1973},
      title = {Symbolic descriptions of factorial models for analysis of variance},
      journal = {Applied Statistics},
      edition = {22},
      pages = {392--9},
    }
    
    @Article{harville:1974,
      author = {D.A. Harville},
      year = {1974},
      title = {Bayesian inference for variance components using only error contrasts},
      journal = {Biometrika},
      edition = {61},
      pages = {383--385},
    }
    
    @Article{haberman:1972,
      author = {S. J. Haberman},
      year = {1972},
      title = {Log-linear fit for contingency tables---Algorithm AS51},
      journal = {Applied Statistics},
      edition = {21},
      pages = {218--225},
    }
    
    @Article{cleveland:1979,
      author = {W. S. Cleveland},
      year = {1979},
      title = {Robust locally weighted regression and smoothing scatterplots},
      journal = {Journal of the American Statistical Association},
      edition = {74},
      pages = {829--836},
    }
    
    @Article{cleveland:1981,
      author = {W. S. Cleveland},
      year = {1981},
      title = {LOWESS: A program for smoothing scatterplots by robust locally weighted regression},
      journal = {The American Statistician},
      edition = {35},
      pages = {54},
    }
    
    @Book{krzanowski:1988,
      author = {W. J. Krzanowski},
      year = {1988},
      title = {Principles of Multivariate Analysis. A User's Perspective.},
      publisher = {Oxford University Press},
    }
    
    @Book{krzanowski+marriott:1994,
      author = {W. J. Krzanowski and F. H. C. Marriott},
      year = {1994},
      title = {Multivariate Analysis. Part I: Distributions, Ordination and Inference},
      publisher = {Edward Arnold},
    }
    
    @Book{anderson:1958,
      author = {T. W. Anderson},
      year = {1958},
      title = {An Introduction to Multivariate Statistical Analysis},
      publisher = {Wiley},
    }
    
    @Book{anderson:1994,
      author = {T. W. Anderson},
      year = {1994},
      title = {An Introduction to Multivariate Statistical Analysis},
      publisher = {Wiley},
    }
    
    @Article{mielke:1967,
      author = {Paul W. {Mielke Jr.}},
      year = {1967},
      title = {Note on some squared rank tests with existing ties},
      journal = {Technometrics},
      edition = {9},
      number = {2},
      pages = {312--314},
    }
    
    @Book{dennis+schnabel:1983,
      author = {J. E. Dennis and R. B. Schnabel},
      year = {1983},
      title = {Numerical Methods for Unconstrained Optimization and Nonlinear Equations},
      publisher = {Prentice-Hall},
      address = {Englewood Cliffs, NJ},
    }
    
    @Article{schnabel+koontz+weiss:1985,
      author = {R. B. Schnabel and J. E. Koontz and B. E. Weiss},
      year = {1985},
      title = {A modular system of algorithms for unconstrained minimization},
      journal = {ACM Trans. Math. Software},
      edition = {11},
      pages = {419--440},
    }
    
    @Book{bates+watts:1988,
      author = {D. M. Bates and D. G. Watts},
      year = {1988},
      title = {Nonlinear Regression Analysis and Its Applications},
      publisher = {Wiley},
    }
    
    @Article{welch:1951,
      author = {B. L. Welch},
      year = {1951},
      title = {On the comparison of several mean values: an alternative approach},
      journal = {Biometrika},
      edition = {38},
      pages = {330--336},
    }
    
    @Book{brent:1973,
      author = {R. Brent},
      year = {1973},
      title = {Algorithms for Minimization without Derivatives},
      address = {Englewood Cliffs N.J.},
      publisher = {Prentice-Hall},
    }
    
    @Article{belisle:1992,
      author = {C. J. P. Belisle},
      year = {1992},
      title = {Convergence theorems for a class of simulated annealing algorithms on \eqn{R^d}{Rd}},
      journal = {Journal of Applied Probability},
      edition = {29},
      pages = {885--895},
    }
    
    @Article{byrd+nocedal+zhu:1995,
      author = {R. H. Byrd and P. Lu and J. Nocedal and C. Zhu},
      year = {1995},
      title = {A limited memory algorithm for bound constrained optimization},
      journal = {SIAM J. Scientific Computing},
      edition = {16},
      pages = {1190--1208},
    }
    
    @Article{fletcher+reeves:1964,
      author = {R. Fletcher and C. M. Reeves},
      year = {1964},
      title = {Function minimization by conjugate gradients},
      journal = {Computer Journal},
      edition = {7},
      pages = {148--154},
    }
    
    @Book{nash:1990,
      author = {J. C. Nash},
      year = {1990},
      title = {Compact Numerical Methods for Computers. Linear Algebra and Function Minimisation.},
      publisher = {Adam Hilger},
    }
    
    @Article{nelder+mead:1965,
      author = {J. A. Nelder and R. Mead},
      year = {1965},
      title = {A simplex algorithm for function minimization},
      journal = {Computer Journal},
      edition = {7},
      pages = {308--313},
    }
    
    @Book{nocedal+wright:1999,
      author = {J. Nocedal and S. J. Wright},
      year = {1999},
      title = {Numerical Optimization},
      publisher = {Springer},
    }
    
    @Article{benjamini+hochberg:1995,
      author = {Y. Benjamini and Y. Hochberg},
      year = {1995},
      title = {Controlling the false discovery rate: a practical and powerful approach to multiple testing},
      journal = {Journal of the Royal Statistical Society},
      series = {B},
      edition = {57},
      pages = {289--300},
    }
    
    @Article{benjamini+yekutieli:2001,
      author = {Y. Benjamini and D. Yekutieli},
      year = {2001},
      title = {The control of the false discovery rate in multiple testing under dependency},
      journal = {Annals of Statistics},
      edition = {29},
      pages = {1165--1188},
    }
    
    @Article{holm:1979,
      author = {S. Holm},
      year = {1979},
      title = {A simple sequentially rejective multiple test procedure},
      journal = {Scandinavian Journal of Statistics},
      edition = {6},
      pages = {65--70},
    }
    
    @Article{hommel:1988,
      author = {G. Hommel},
      year = {1988},
      title = {A stagewise rejective multiple test procedure based on a modified Bonferroni test},
      journal = {Biometrika},
      edition = {75},
      pages = {383--386},
    }
    
    @Article{hochberg:1988,
      author = {Y. Hochberg},
      year = {1988},
      title = {A sharper Bonferroni procedure for multiple tests of significance},
      journal = {Biometrika},
      edition = {75},
      pages = {800--803},
    }
    
    @Article{schaffer:1995,
      author = {J. P. Shaffer},
      year = {1995},
      title = {Multiple hypothesis testing},
      journal = {Annual Review of Psychology},
      edition = {46},
      pages = {561--576},
    }
    
    @Article{sarkar:1998,
      author = {S. Sarkar},
      year = {1998},
      title = {Some probability inequalities for ordered MTP2 random variables: a proof of Simes conjecture},
      journal = {Annals of Statistics},
      edition = {26},
      pages = {494--504},
    }
    
    @Article{sarkar+chang:1997,
      author = {S. Sarkar and C. K. Chang},
      year = {1997},
      title = {Simes' method for multiple hypothesis testing with positively dependent test statistics},
      journal = {Journal of the American Statistical Association},
      edition = {92},
      pages = {1601--1608},
    }
    
    @Article{wright:1992,
      author = {S. P. Wright},
      year = {1992},
      title = {Adjusted P-values for simultaneous inference},
      journal = {Biometrics},
      edition = {48},
      pages = {1005--1013},
    }
    
    @TechReport{holt:1957,
      author = {C. C. Holt},
      year = {1957},
      title = {Forecasting seasonals and trends by exponentially weighted moving averages},
      note = {ONR Research Memorandum},
      institution = {Carnigie Institute 52},
    }
    
    @Book{cook+weisberg:1982,
      author = {R. D. Cook and S. Weisberg},
      year = {1982},
      title = {Residuals and Influence in Regression},
      address = {London},
      publisher = {Chapman and Hall},
    }
    
    @InBook{firth:1991,
      author = {D. Firth},
      year = {1991},
      chapter = {Generalized Linear Models},
      editor = {D. V. Hinkley and N. Reid and E. J. Snell},
      title = {Statistical Theory and Modelling. In Honour of Sir David Cox, FRS.},
      address = {London},
      publisher = {Chapman and Hall},
      pages = {55-82},
    }
    
    @Article{hinkley:1975,
      author = {D. V. Hinkley},
      year = {1975},
      title = {On power transformations to symmetry},
      journal = {Biometrika},
      edition = {62},
      pages = {101--111},
    }
    
    @Book{kennedy+gentle:1980,
      author = {W. J. {Kennedy Jr.} and J. E. Gentle},
      year = {1980},
      title = {Statistical Computing},
      publisher = {Marcel Dekker},
    }
    
    @Book{blom:1958,
      author = {G. Blom},
      year = {1958},
      title = {Statistical Estimates and Transformed Beta Variables},
      publisher = {Wiley},
    }
    
    @Article{friedman+stuetzle:1981,
      author = {J. H. Friedman and W. Stuetzle},
      year = {1981},
      title = {Projection pursuit regression},
      journal = {Journal of the American Statistical Association},
      edition = {76},
      pages = {817--823},
    }
    
    @TechReport{friedman:1984,
      author = {J. H. Friedman},
      year = {1984},
      title = {SMART User's Guide},
      institution = {Laboratory for Computational Statistics, Stanford University},
      note = {Technical Report No. 1},
    }
    
    @TechReport{friedman:1984,
      author = {J. H. Friedman},
      year = {1984},
      title = {A variable span scatterplot smoother},
      institution = {Laboratory for Computational Statistics, Stanford University},
      note = {Technical Report No. 5},
    }
    
    @Book{banerjee+dolado+galbraith+hendry:1993,
      author = {A. Banerjee and J. J. Dolado and J. W. Galbraith and D. F. Hendry},
      year = {1993},
      title = {Cointegration, Error Correction, and the Econometric Analysis of Non-Stationary Data},
      publisher = {Oxford University Press},
      address = {Oxford},
    }
    
    @Article{perron:1988,
      author = {P. Perron},
      year = {1988},
      title = {Trends and random walks in macroeconomic time series},
      journal = {Journal of Economic Dynamics and Control},
      edition = {12},
      pages = {297--332},
    }
    
    @Article{wilson:1927,
      author = {E. B. Wilson},
      year = {1927},
      title = {Probable inference, the law of succession, and statistical inference},
      journal = {Journal of the American Statistical Association},
      edition = {22},
      pages = {209--212},
    }
    
    @Article{newcombe:1988a,
      author = {R. G. Newcombe},
      year = {1998},
      title = {Two-Sided Confidence Intervals for the Single Proportion: Comparison of Seven Methods},
      journal = {Statistics in Medicine},
      edition = {17},
      pages = {857--872},
    }
    
    @Article{newcombe:1988b,
      author = {R. G. Newcombe},
      year = {1998},
      title = {Interval Estimation for the Difference Between Independent Proportions: Comparison of Eleven Methods},
      journal = {Statistics in Medicine},
      edition = {17},
      pages = {873--890},
    }
    
    @Article{quade:1979,
      author = {D. Quade},
      year = {1979},
      title = {Using weighted rankings in the analysis of complete blocks with additive block effects},
      journal = {Journal of the American Statistical Association},
      edition = {74},
      pages = {680--683},
    }
    
    @Article{hyndman+fan:1996,
      author = {R. J. Hyndman and Y. Fan},
      year = {1996},
      title = {Sample quantiles in statistical packages},
      journal = {American Statistician},
      edition = {50},
      pages = {361--365},
    }
    
    @Article{haerdle:1995,
      author = {W. Härdle and W. Steiger},
      year = {1995},
      title = {[Algorithm AS 296] Optimal median smoothing},
      journal = {Applied Statistics},
      edition = {44},
      pages = {258--264},
    }
    
    @TechReport{friedman+stuetzle:1982,
      author = {Jerome H. Friedman and Werner Stuetzle},
      year = {1982},
      title = {Smoothing of Scatterplots},
      institution = {Dep. Statistics, Stanford U.},
      note = {Report, Project Orion 003},
    }
    
    @Misc{maechler:2003,
      author = {Martin Maechler},
      year = {2003},
      title = {Fast Running Medians: Finite Sample and Asymptotic Optimality},
      note = {working paper available from the author},
    }
    
    @Article{royston:1982a,
      author = {Patrick Royston},
      year = {1982},
      title = {An extension of Shapiro and Wilk's \eqn{W} test for normality to large samples},
      journal = {Applied Statistics},
      edition = {31},
      pages = {115--124},
    }
    
    @Article{royston:1982b,
      author = {Patrick Royston},
      year = {1982},
      title = {Algorithm AS 181: The \eqn{W} test for Normality},
      journal = {Applied Statistics},
      edition = {31},
      pages = {176--180},
    }
    
    @Article{royston:1995,
      author = {Patrick Royston},
      year = {1995},
      title = {Remark AS R94: A remark on Algorithm AS 181: The \eqn{W} test for normality},
      journal = {Applied Statistics},
      edition = {44},
      pages = {547--551},
    }
    
    @Book{velleman+hoaglin:1981,
      author = {P. F. Velleman and D. C. Hoaglin},
      year = {1981},
      title = {ABC of EDA (Applications, Basics, and Computing of Exploratory Data Analysis)},
      publisher = {Duxbury},
    }
    
    @Book{green+silverman:1994,
      author = {P. J. Green and B. W. Silverman},
      year = {1994},
      title = {Nonparametric Regression and Generalized Linear Models: A Roughness Penalty Approach},
      publisher = {Chapman and Hall},
    }
    
    @Book{hastie+tibshirani:1990,
      author = {T. J. Hastie and R. J. Tibshirani},
      year = {1990},
      title = {Generalized Additive Models},
      publisher = {Chapman and Hall},
    }
    
    @Article{thompson:1990,
      author = {D.J. Thompson},
      year = {1990},
      title = {Time series analysis of Holocene climate data},
      journal = {Phil. Trans. Roy. Soc. A},
      edition = {330},
      pages = {601--616},
    }
    
    @Book{bloomfield:1976,
      author = {P. Bloomfield},
      year = {1976},
      title = {Fourier Analysis of Time Series: An Introduction},
      publisher = {Wiley},
    }
    
    @Book{forsythe+malcolm+moler:1977,
      author = {G. E. Forsythe and M. A. Malcolm and C. B. Moler},
      year = {1977},
      title = {Computer Methods for Mathematical Computations},
      publisher = {Prentice Hall},
    }
    
    @Article{fritsch+carlson:1980,
      author = {F. N. Fritsch and R. E. Carlson},
      year = {1980},
      title = {Monotone piecewise cubic interpolation},
      journal = {SIAM Journal on Numerical Analysis},
      edition = {17},
      pages = {238--246},
    }
    
    @Book{ratkowsky:1983,
      author = {David A. Ratkowsky},
      year = {1983},
      title = {Nonlinear Regression Modeling},
      publisher = {Dekker},
    }
    
    @Article{cleveland+cleveland+mcrae+terpenning:1990,
      author = {R. B. Cleveland and W. S. Cleveland and J.E. McRae and I. Terpenning},
      year = {1990},
      title = {STL:  A  Seasonal-Trend  Decomposition  Procedure Based on Loess},
      journal = {Journal of Official Statistics},
      edition = {6},
      pages = {3--73},
    }
    
    @Book{harvey:1989,
      author = {A. C. Harvey},
      year = {1989},
      title = {Forecasting, Structural Time Series Models and the Kalman Filter},
      publisher = {Cambridge University Press},
    }
    
    @Book{miller:1981,
      author = {R. G. Miller},
      year = {1981},
      title = {Simultaneous Statistical Inference},
      publisher = {Springer},
    }
    
    @Book{yandell:1997,
      author = {B. S. Yandell},
      year = {1997},
      title = {Practical Data Analysis for Designed Experiments},
      publisher = {Chapman & Hall},
    }
    
    @Article{copenhaver+holland:1988,
      author = {Margaret Diponzio Copenhaver and Burt S. Holland},
      year = {1988},
      title = {Multiple comparisons of simple effects in the two-way analysis of variance with fixed effects},
      journal = {Journal of Statistical Computation and Simulation},
      edition = {30},
      pages = {1--15},
    }
    
    @Article{hendrickson+white:1964,
      author = {A. E. Hendrickson and P. O. White},
      year = {1964},
      title = {Promax: a quick method for rotation to orthogonal oblique structure},
      journal = {British Journal of Statistical Psychology},
      edition = {17},
      pages = {65--70},
    }
    
    @Book{horst:1965,
      author = {P. Horst},
      year = {1965},
      title = {Factor Analysis of Data Matrices},
      publisher = {Holt, Rinehart and Winston},
    }
    
    @Article{kaiser:1958,
      author = {H. F. Kaiser},
      year = {1958},
      title = {The varimax criterion for analytic rotation in factor analysis},
      journal = {Psychometrika},
      edition = {23},
      pages = {187--200},
    }

# Read stats4

    Schwarz G (1978). "Estimating the Dimension of a Model." _Annals of
    Statistics_, 461-464.

---

    @Article{schwarz:1978,
      author = {G. Schwarz},
      year = {1978},
      title = {Estimating the Dimension of a Model},
      journal = {Annals of Statistics},
      edition = {6},
      pages = {461--464},
    }

# Read tools

    Murdoch D (2009). "Parsing Rd files."
    <http://developer.r-project.org/parseRd.pdf>.

---

    @Misc{murdoch:2009,
      author = {Duncan Murdoch},
      title = {Parsing Rd files},
      year = {2009},
      url = {http://developer.r-project.org/parseRd.pdf},
    }

# Read utils

    Nijenhuis A, Wilf H (1978). _Combinatorial Algorithms for Computers and
    Calculators_. Academic Press, New York.
    
    Robbins KA, Robbins S (1995). _Practical UNIX Programming_, 1st
    edition. Prentice Hall PTR. ISBN 0134437063.
    
    Leisch F (2008). _Sweave User Manual_.
    <http://www.stat.uni-muenchen.de/~leisch/Sweave>.

---

    @Book{nijenhuis+wilf:1978,
      author = {A. Nijenhuis and H.S. Wilf},
      year = {1978},
      title = {Combinatorial Algorithms for Computers and Calculators},
      publisher = {Academic Press},
      address = {New York},
    }
    
    @Book{robbins+robbins:1995,
      author = {Kay A. Robbins and Steven Robbins},
      edition = {1st},
      howpublished = {Hardcover},
      isbn = {0134437063},
      keywords = {programming, unix},
      month = {November},
      publisher = {Prentice Hall PTR},
      title = {Practical UNIX Programming},
      year = {1995},
    }
    
    @Manual{leisch:2008,
      author = {Friedrich Leisch},
      title = {Sweave User Manual},
      year = {2008},
      url = {http://www.stat.uni-muenchen.de/~leisch/Sweave},
    }

