% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_mds.R
\name{fast_mds}
\alias{fast_mds}
\title{Fast MDS}
\usage{
fast_mds(x, l, s_points, r, n_cores)
}
\arguments{
\item{x}{A matrix with \eqn{n} individuals (rows) and \eqn{k} variables (columns).}

\item{l}{The size for which classical MDS can be computed efficiently
(using \code{cmdscale} function). It means that if \eqn{\bar{l}} is the limit
size for which classical MDS is applicable, then \code{l}\eqn{\leq \bar{l}}.}

\item{s_points}{Number of points used to align the MDS solutions obtained by
the division of \code{x} into \eqn{p} submatrices. Recommended value: \code{5·r}.}

\item{r}{Number of principal coordinates to be extracted.}

\item{n_cores}{Number of cores wanted to use to run the algorithm.}
}
\value{
Returns a list containing the following elements:
\describe{
\item{points}{A matrix that consists of \eqn{n} individuals (rows)
and \code{r} variables (columns) corresponding to the principal coordinates. Since
we are performing a dimensionality reduction, \code{r}\eqn{<<k}}
\item{eigen}{The first \code{r} largest eigenvalues:
\eqn{\bar{\lambda}_i, i \in  \{1, \dots, r\} }, where
\eqn{\bar{\lambda}_i = 1/p \sum_{j=1}^{p}\lambda_i^j/n_j},
being \eqn{\lambda_i^j} the \eqn{i-th} eigenvalue from partition \eqn{j}
and \eqn{n_j} the size of the partition \eqn{j}.}
}
}
\description{
Fast MDS uses recursive programming in combination with a divide
and conquer strategy in order to obtain an MDS configuration for a given
large data set \code{x}.
}
\details{
Fast MDS randomly divides the whole sample data set, \code{x}, of size \eqn{n}
into \eqn{p=}\code{l/s_points} data subsets, where \code{l} \eqn{\leq \bar{l}} being \eqn{\bar{l}}
the limit size for which classical MDS is applicable. Each one of the \eqn{p} data subsets
has size \eqn{\tilde{n} = n/p}. If \eqn{\tilde{n} \leq \code{l}} then classical MDS is applied
to each data subset. Otherwise, fast MDS is recursively applied.
In either case, a final MDS configuration is obtained for each data subset.

In order to align all the partial solutions, a small subset of size \code{s_points}
is randomly selected from each data subset. They are joined
to form an alignment set, over which classical MDS is performed giving rise to an
alignment configuration. Every data subset shares \code{s_points} points with the alignment
set. Therefore every MDS configuration can be aligned with the alignment configuration
using a Procrustes transformation.
}
\examples{
set.seed(42)
x <- matrix(data = rnorm(4 * 10000), nrow = 10000) \%*\% diag(c(9, 4, 1, 1))
mds <- fast_mds(x = x, l = 200, s_points = 5 * 2, r = 2, n_cores = 1)
head(mds$points)
mds$eigen

}
\references{
Delicado P. and C. Pachón-García (2021). \emph{Multidimensional Scaling for Big Data}.
\url{https://arxiv.org/abs/2007.11919}.

Yang, T., J. Liu, L. McMillan and W.Wang (2006). \emph{A fast approximation to multidimensional scaling}.
In Proceedings of the ECCV Workshop on Computation Intensive Methods for Computer Vision (CIMCV).

Borg, I. and P. Groenen (2005). \emph{Modern Multidimensional Scaling: Theory and Applications}. Springer.
}
