% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomialtrend.R
\name{binomialtrend}
\alias{binomialtrend}
\title{Calculates The Statistical Significance Of A Teend In A Set Of Measurements}
\arguments{
\item{data}{a data frame with the measurement values}
}
\value{
The p-value and trend value of the data
}
\description{
The package calculates whether there is a statistically significant trend
in the date provided by the user. This is based on the a signed test based on the binomial
distribution. The package returns a trend test value, T, and also a p-value. A T value
close to 1 indicates a rising trend, whereas a T value close to -1 indicates a decreasing
trend. A T value close to 0 indicates no trend. There is also a command to create a
heatmap visualizing the trend.

Version 0.0.1.
Author: Dr. Matthew Cserhati
Email: csmatyi@protonmail.com
December 14, 2022
}
\examples{
meas <- c(1.1,4.5,7.8,5.9,10.2)
binomialtrend(meas)
binomialtrend(c(1,2,3,4,2,4,5,6,8,5,4,7,10,11))

}
\references{
Walpole, Myers, Myers, Ye. (2007) Probability & Statistics for Engineers and Scientists. Upper Saddle River, NJ, Pearson Prentice Hall.
}
