% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices_and_positions.R
\name{get_ngrams_ind}
\alias{get_ngrams_ind}
\title{Get indices of n-grams}
\usage{
get_ngrams_ind(len_seq, n, d)
}
\arguments{
\item{len_seq}{\code{integer} value describing sequence's length.}

\item{n}{\code{integer} size of n-gram.}

\item{d}{\code{integer} vector of distances between elements of n-gram (0 means 
consecutive elements). See Details.}
}
\value{
A list with number of elements equal to \code{n}. Every element is a 
vector containing locations of given n-gram letter. For example, first element of
list contain indices of first letter of all n-grams. The attribute \code{d}
of output contains distances between letter used to compute locations 
(see Details).
}
\description{
Computes list of n-gram elements positions in sequence.
}
\details{
A format of \code{d} vector is discussed in Details of 
\code{\link{count_ngrams}}.
}
\examples{
# positions trigrams in sequence of length 10
get_ngrams_ind(10, 9, 0)
}
