% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBioSet.R
\name{getBioSet}
\alias{getBioSet}
\title{Generic Bio data set extractor}
\usage{
getBioSet(
  db = "refseq",
  organisms,
  set_type,
  reference = FALSE,
  release = NULL,
  gunzip = TRUE,
  update = FALSE,
  skip_bacteria = TRUE,
  path = paste0("set_", toupper(set_type)),
  remove_annotation_outliers = FALSE,
  assembly_type = "toplevel",
  format = "gff3",
  mute_citation = FALSE
)
}
\arguments{
\item{db}{a character string specifying the database from which the genome
shall be retrieved:
\itemize{
\item \code{db = "refseq"}
\item \code{db = "genbank"}
\item \code{db = "ensembl"}
}}

\item{organisms}{a character vector storing the names of the organisms than shall be retrieved.
There are three available options to characterize an organism:}

\item{set_type}{the biological sequence type that shall be retrieved.
Available options are
\itemize{
\item \code{set_type = "genome"}
\item \code{set_type = "proteome"}
\item \code{set_type = "cds"}
\item \code{set_type = "gff"}
\item \code{set_type = "rna"}
\item \code{set_type = "assembly_stats"}
\item \code{set_type = "repeat_masker"}
\item \code{set_type = "collection"} (all the others)
}}

\item{reference}{a logical value indicating whether or not a genome shall be downloaded if it isn't marked in the database as either a reference genome or a representative genome.}

\item{release}{a numeric, the database release version of ENSEMBL (\code{db = "ensembl"}). Default is \code{release = NULL} meaning
that the most recent database version is used. \code{release = 75} would for human would give the stable
GRCh37 release in ensembl. Value must be > 46, since ensembl did not structure their data
if the standard format before that.}

\item{gunzip}{a logical, indicating whether or not files should be unzipped.}

\item{update}{logical, default FALSE. Updated backend cached files needed.
Usually keep this false, to make ut run much faster. Only set to TRUE, if you
believe you cache is outdated (Species only exist in newest release etc)}

\item{skip_bacteria}{Due to its enormous dataset size (> 700MB as of July 2023),
the bacterial summary file will not be loaded by default anymore. If users
wish to gain insights for the bacterial kingdom they needs to actively specify \code{skip_bacteria = FALSE}. When \code{skip_bacteria = FALSE} is set then the
bacterial summary file will be downloaded.}

\item{path}{character, default location is paste0("set_", toupper(set_type))}

\item{remove_annotation_outliers}{shall outlier lines be removed from the input \code{annotation_file}?
If yes, then the initial \code{annotation_file} will be overwritten and the removed outlier lines will be stored at \code{\link{tempdir}}
for further exploration.}

\item{assembly_type}{character, default c("primary_assembly", "toplevel"). Used for ensembl only,
specifies the genome assembly type. Searches for both primary and toplevel, and if both are found, uses the
first by order (so primary is prioritized by default).
The Primary assembly should usually be used if it exists.
The "primary assembly" contains all the top-level sequence regions,
excluding alternative haplotypes and patches.
If the primary assembly file is not present for a species
(only defined for standard model organisms),
that indicates that there were no haplotype/patch regions,
and in such cases, the 'toplevel file is used.
For more details see:
\href{https://grch37.ensembl.org/info/genome/genebuild/assembly.html}{ensembl tutorial}}

\item{format}{"gff3", alternative "gtf" for ensembl.}

\item{mute_citation}{logical, default FALSE, indicating whether citation message should be muted.}
}
\value{
File path to downloaded genomes
(names are identifiers: 'new' (file was downloaded now),
'old' files did already exist)
}
\description{
Usually you want to use one of the specific set extractors
}
\details{
Internally this function loads the the overview.txt file from NCBI:

 refseq: ftp://ftp.ncbi.nlm.nih.gov/genomes/refseq/

 genbank: ftp://ftp.ncbi.nlm.nih.gov/genomes/genbank/

and creates a directory 'set_CDSs' to store
the CDSs of interest as fasta files for future processing.
In case the corresponding fasta file already exists within the
'set_CDSs' folder and is accessible within the workspace,
no download process will be performed.
}
\examples{
\dontrun{
getBioSet("refseq", organisms = c("Arabidopsis thaliana",
                                  "Arabidopsis lyrata",
                                  "Capsella rubella"),
                                  set_type = "cds")
}
}
\seealso{
\code{\link{getBio}}

Other getBioSet: 
\code{\link{getCDSSet}()},
\code{\link{getCollectionSet}()},
\code{\link{getGFFSet}()},
\code{\link{getGenomeSet}()},
\code{\link{getProteomeSet}()},
\code{\link{getRNASet}()}
}
\author{
Hajk-Georg Drost
}
\concept{getBioSet}
